% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tropical.ball.verts.R
\name{trop_bal.vert}
\alias{trop_bal.vert}
\title{Calculate the minimum generating vertex set of a tropical ball}
\usage{
trop_bal.vert(x, d, al = FALSE)
}
\arguments{
\item{x}{matrix where each row is a point defining a tropical polytope}

\item{d}{radius of the tropical ball in terms of tropical distance}

\item{al}{logical; TRUE or FALSE to determine whether to enumerate all vertices of the tropical ball}
}
\value{
matrix of normalized tropical points defining the tropical ball. Rows are the points
}
\description{
This function calculates the coordinates of the minimum or entire vertex set of a tropical ball given a center point
}
\examples{
x <-c(0,3,7,5)
d <- 2
trop_bal.vert(x,d)
trop_bal.vert(x,d,al=TRUE)
}
\references{
Barnhill, David, Ruriko Yoshida and Keiji Miura (2023). Maximum Inscribed and Minimum Enclosing Tropical Balls of Tropical Polytopes and Applications to Volume Estimation and Uniform Sampling.
}
\author{
David Barnhill \email{david.barnhill@nps.edu}
}
