% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{normalize}
\alias{normalize}
\title{Normalize process likelihood using the Laplace approximation.}
\usage{
normalize(obj, flag, value = 0)
}
\arguments{
\item{obj}{Model object from \code{MakeADFun} without proper normalization of the random effect likelihood.}

\item{flag}{Flag to disable the data term from the model.}

\item{value}{Value of 'flag' that signifies to not include the data term.}
}
\value{
Modified model object that can be passed to an optimizer.
}
\description{
If the random effect likelihood contribution of a model has been
implemented without proper normalization (i.e. lacks the normalizing
constant), then this function can perform the adjustment
automatically. In order for this to work, the model must include a
flag that disables the data term so that the un-normalized random effect
(negative log) density is returned from the model template.
Automatic process normalization may be useful if either the
normalizing constant is difficult to implement, or if its calulation
involves so many operations that it becomes infeasible to include in
the AD machinery.
}

