% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_TL.MAAD.R
\name{plot_TL.MAAD}
\alias{plot_TL.MAAD}
\title{plot MAAD result}
\usage{
plot_TL.MAAD(sample.name, temperatures, eval.Tmin, eval.Tmax, aNames, aDoses,
  aLx, aTx, aLxTx, aLx.plateau, aTx.plateau, aLxTx.plateau, rNames, rDoses, rLx,
  rTx, rLxTx, rLx.plateau, rTx.plateau, rLxTx.plateau, DP.Q.line,
  DP.Q.line.error, GC.Q.line, GC.Q.slope, GC.Q.LxTx, GC.Q.LxTx.error,
  GC.Q.doses, GC.Q.names, DP.I.line, DP.I.line.error, GC.I.line, GC.I.slope,
  GC.I.LxTx, GC.I.LxTx.error, GC.I.doses, GC.I.names, Q.DP, Q.DP.error, Q.GC,
  Q.GC.error, I.DP, I.DP.error, I.GC, I.GC.error, De.GC, De.GC.error, De.DP,
  De.DP.error, rejection.values, fitting.parameters,
  plotting.parameters = list(plot.Tmin = 0, plot.Tmax = NA))
}
\arguments{
\item{sample.name}{\link{character} (\bold{required}): Sample name.}

\item{temperatures}{\link{numeric} (\bold{required}): temperature vector}

\item{eval.Tmin}{\link{integer} (\bold{required}): Temperature (°C) of the lower boundary for the signal integration.}

\item{eval.Tmax}{\link{integer} (\bold{required}): Temperature (°C) of the upper boundary for the signal integration.}

\item{aNames}{\link{character} (\bold{required}): Name vector for the additive curves.}

\item{aDoses}{\link{numeric} (\bold{required}): Dose vector for the additive curves.}

\item{aLx}{\link{numeric} (\bold{required}): Lx matrix for the additive curves.}

\item{aTx}{\link{numeric} (\bold{required}): Tx matrix for the additive curves.}

\item{aLxTx}{\link{numeric} (\bold{required}): Lx/Tx matrix for the additive curves.}

\item{aLx.plateau}{\link{numeric} (\bold{required}): Ln/Lx matrix for the additive curves.}

\item{aTx.plateau}{\link{numeric} (\bold{required}): Ln/Tx matrix for the additive curves.}

\item{aLxTx.plateau}{\link{numeric} (\bold{required}): (Ln/Tn)/(Lx/Tx) matrix for the additive curves.}

\item{rNames}{\link{character} (\bold{required}): Name vector for the regenerative curves.}

\item{rDoses}{\link{numeric} (\bold{required}): Dose vector for the regenerative curves.}

\item{rLx}{\link{numeric} (\bold{required}): Lx matrix for the regenerative curves.}

\item{rTx}{\link{numeric} (\bold{required}): Tx matrix for the regenerative curves.}

\item{rLxTx}{\link{numeric} (\bold{required}): Lx/Tx matrix for the regenerative curves.}

\item{rLx.plateau}{\link{numeric} (\bold{required}): Ln/Lx matrix for the regenerative curves.}

\item{rTx.plateau}{\link{numeric} (\bold{required}): Tn/Tx matrix for the regenerative curves.}

\item{rLxTx.plateau}{\link{numeric} (\bold{required}): (Ln/Tn)/(Lx/Tx) matrix for the regenerative curves.}

\item{DP.Q.line}{\link{numeric} (\bold{required}): Vector containing the estimation of Q for each T° step.}

\item{DP.Q.line.error}{\link{numeric} (\bold{required}): Vector containing the uncertainty on the estimation of Q for each T° step.}

\item{GC.Q.line}{\link{numeric} (\bold{required}): growth curve for Q}

\item{GC.Q.slope}{\link{numeric} (\bold{required}): growth curve parameters for Q}

\item{GC.Q.LxTx}{\link{numeric} (\bold{required}): Lx/Tx vector used for Q estimation using the growth curve approach.}

\item{GC.Q.LxTx.error}{\link{numeric} (\bold{required}): Error on the Lx/tx vector used for Q estimation using the growth curve approach.}

\item{GC.Q.doses}{\link{numeric} (\bold{required}): Doses used for Q estimation using the growth curve approach.}

\item{GC.Q.names}{\link{numeric} (\bold{required}): Names of the Lx/tx vector used for Q estimation using the growth curve approach.}

\item{DP.I.line}{\link{numeric} (\bold{required}): Vector containing I for each temperature step.}

\item{DP.I.line.error}{\link{numeric} (\bold{required}): Vector containing the uncertainty on I for each temperature step.}

\item{GC.I.line}{\link{numeric} (\bold{required}): growth curve for I}

\item{GC.I.slope}{\link{numeric} (\bold{required}): growth curve parameters for I.}

\item{GC.I.LxTx}{\link{numeric} (\bold{required}): Lx/tx vector used for I estimation using the growth curve approach.}

\item{GC.I.LxTx.error}{\link{numeric} (\bold{required}): Error on the Lx/tx vector used for I estimation using the growth curve approach.}

\item{GC.I.doses}{\link{numeric} (\bold{required}): Doses used for I estimation using the growth curve approach.}

\item{GC.I.names}{\link{numeric} (\bold{required}): Names of the Lx/Tx vector used for I estimation using the growth curve approach.}

\item{Q.DP}{\link{numeric} (\bold{required}): Q estimation using the dose plateau approach}

\item{Q.DP.error}{\link{numeric} (\bold{required}): Uncertainty on the Q estimation using the dose plateau approach}

\item{Q.GC}{\link{numeric} (\bold{required}): Q estimation using the growth curve approach}

\item{Q.GC.error}{\link{numeric} (\bold{required}): Uncertainty on the Q estimation using the growth curve approach}

\item{I.DP}{\link{numeric} (\bold{required}): I estimation using the dose plateau approach}

\item{I.DP.error}{\link{numeric} (\bold{required}): Uncertainty on the I estimation using the dose plateau approach}

\item{I.GC}{\link{numeric} (\bold{required}): I estimation using the growth curve approach}

\item{I.GC.error}{\link{numeric} (\bold{required}): Uncertainty on the I estimation using the growth curve approach}

\item{De.GC, }{\link{numeric} (\bold{required}): ED (Q+I) estimation using the growth curve approach}

\item{De.GC.error, }{\link{numeric} (\bold{required}): Uncertainty on the ED (Q+I) estimation using the growth curve approach}

\item{De.DP, }{\link{numeric} (\bold{required}): ED (Q+I) estimation using the dose plateau approach}

\item{De.DP.error}{\link{numeric} (\bold{required}): Uncertainty on the ED (Q+I) estimation using the dose plateau approach}

\item{rejection.values}{\link{list} (\bold{required}): result of the rejection tests.}

\item{fitting.parameters}{\link{list} (with default): list containing the fitting parameters. See details.}

\item{plotting.parameters}{\link{list} (with default): list containing the plotting parameters. See details.}
}
\description{
This function plots the results for \link{analyse_TL.MAAD}.
The first page regroups all the information about the additive curves (names, doses, intensity vs. temperature and plateau test for Lx, Tx and Lx/Tx).
The second page regroups all the information about the regenerative curves (names, doses, intensity vs. temperature and plateau test for Lx, Tx and Lx/Tx).
The third page regroups all the information about the equivalent dose (dose plateau for the palaeodose and the supralinearity correction, growth curves, rejection criteria,...).
}
\details{
\bold{Fitting parameters} \cr
The fitting parameters are:  \cr
\describe{
 \item{\code{method}}{
   \link{character}: Fitting method (\code{LIN}, \code{EXP}, \code{EXP+LIN} or \code{EXP+EXP}).}
 \item{\code{fit.weighted}}{
   \link{logical}: If the fitting is weighted or not.}
 \item{\code{fit.use.slope}}{
   \link{logical}: If the slope of the Q growth curve is reused for the supralinearity correction.}
 \item{\code{fit.aDoses.min}}{
   \link{numeric}: Lowest additive dose used for the fitting.}
 \item{\code{fit.aDoses.max}}{
   \link{numeric}: Highest additive dose used for the fitting.}
 \item{\code{fit.rDoses.min}}{
   \link{numeric}: Lowest regenerative dose used for the fitting.}
 \item{\code{fit.rDoses.max}}{
   \link{numeric}: Highest regenerative dose used for the fitting.}
}
See also \link{analyse_TL.MAAD}, \link{calc_TL.MAAD.fit.Q} and \link{calc_TL.MAAD.fit.I}. \cr

\bold{Plotting parameters} \cr
The plotting parameters are:  \cr
\describe{
 \item{\code{plot.Tmin}}{
   \link{numeric}: Lower temperature plotted.}
 \item{\code{plot.Tmax}}{
   \link{numeric}: Higher temperature plotted.}
 \item{\code{no.plot}}{
   \link{logical}: If \code{TRUE}, the results will not be plotted.}
}
See also \link{analyse_TL.MAAD}. \cr
}
\author{
David Strebler
}
\seealso{
\link{analyse_TL.MAAD},
 \link{calc_TL.MAAD.fit.Q},
 \link{calc_TL.MAAD.fit.I}.
}

