% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TLum.BIN.File2TLum.Analysis.R
\name{TLum.BIN.File2TLum.Analysis}
\alias{TLum.BIN.File2TLum.Analysis}
\title{Convert TLum.BIN.File object to an TLum.Analysis object.}
\usage{
TLum.BIN.File2TLum.Analysis(object, protocol = "unknown",
  rec_duringPH = TRUE, rec_ramp2PH = TRUE)
}
\arguments{
\item{object}{\code{\linkS4class{TLum.BIN.File}} (\bold{required}): object containing the luminescence curves.}

\item{protocol}{\link{character} (with default): protocol used.}

\item{rec_duringPH}{\link{logical} (with default): Indicate if the signal was record during the preheat plateau.}

\item{rec_ramp2PH}{\link{logical} (with default): Indicate if the signal was record during the ramp up to the preheat temperature.}
}
\value{
This function will return a \linkS4class{TLum.Analysis} object.
}
\description{
This function convert a \linkS4class{TLum.BIN.File} in a \linkS4class{TLum.Analysis} object.
A \linkS4class{TLum.Analysis} object is a list of \linkS4class{TLum.Data.Curve} object.
It is possible to specify which luminescence curves will be keeped.
}
\author{
David Strebler, University of Cologne (Germany), \cr David Strebler
}
\seealso{
\linkS4class{TLum.Analysis},
 \linkS4class{TLum.BIN.File},
 \linkS4class{TLum.Data.Curve} and
 \link{TLum.BIN.File2TLum.Data.Curve}.
}

