% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tmax.R
\name{Tmax.find}
\alias{Tmax.find}
\title{Find Tmax}
\usage{
Tmax.find(tension, dates, ID)
}
\arguments{
\item{tension}{Vector with tension.}

\item{dates}{Vector with dates in the DOY format.}

\item{ID}{Character vector for specifying which group the tension is assigned to (e.g. trees)}
}
\value{
Return a vector containing daily Tmax for each group specified in the ID argument
}
\description{
Find the daily maximum of tension
}
\examples{
tension = c(1:20)
dates = c(rep(102, times=10), rep(103, times=10))
ID = c(rep("A", times=5), rep("B", times=5), rep("A", times=5), rep("B", times=5))
Tmax.find(tension=tension, dates=dates, ID=ID)
}

