% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate.R
\name{calculate_homology}
\alias{calculate_homology}
\title{Calculate Persistent Homology of a Point Cloud}
\usage{
calculate_homology(mat, dim = 1, threshold = -1)
}
\arguments{
\item{mat}{numeric matrix containing point cloud}

\item{dim}{maximum dimension of features to calculate}

\item{threshold}{maximum diameter for computation of Vietoris-Rips complexes}
}
\value{
3-column matrix, with each row representing a TDA feature
}
\description{
Calculates the persistent homology of a point cloud, as represented by
a Vietoris-Rips complex. This function is an R wrapper for Ulrich Bauer's
Ripser C++ library for calculating persistent homology. For more
information on the C++ library, see <https://github.com/Ripser/ripser>.
}
\details{
The `mat` parameter should be a numeric matrix with each row corresponding
to a single point, and each column corresponding to a single dimension. Thus,
if `mat` has 50 rows and 5 columns, it represents a point cloud with 50 points
in 5 dimensions. The `dim` parameter should be a positive integer.
}
\examples{

# create a 2-d point cloud of a circle (100 points)
num.pts <- 100
rand.angle <- runif(num.pts, 0, 2*pi)
pt.cloud <- cbind(cos(rand.angle), sin(rand.angle))

# calculate persistent homology (num.pts by 3 numeric matrix)
pers.hom <- calculate_homology(pt.cloud)
}
