% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inv_kimesurface_transform.R
\name{inv_kimesurface_transform}
\alias{inv_kimesurface_transform}
\title{inverse kimesurface transform on a function in different periodic ranges}
\usage{
inv_kimesurface_transform(
  time_points,
  array_2d,
  num_length = 20,
  m = 1,
  msg = TRUE
)
}
\arguments{
\item{time_points}{a sequence of points in [0, 2*pi] or other periodic range}

\item{array_2d}{2D array, got from the kimesurface_transform}

\item{num_length}{integer, interpolate f(t) to num_length samples in [0 : 2*pi] to extend the plot}

\item{m}{width of the contour path in C; too small values may lead to singularities on the negative x-axis; 
too large valued may lead to numerical instability for large positive x-axis. The default is 1.}

\item{msg}{Boolean to show/hide warnings. The default is TRUE.}
}
\value{
a list of two elements
\itemize{
  \item Smooth_Reconstruction - the smoothed data computed from inverse kimesurface transform, 
  with the same length of time_points
  \item Raw_Reconstruction - the original unsmoothed data computed from inverse kimesurface transform, 
  with the same length of time_points
}
}
\description{
This function applies the inverse kimesurface transform to convert a kimesurface-transformed function back
to get the original 1D function in [0, 2*pi] or other similar periodic time range.
}
\examples{
require(reshape2)
require(ggplot2)
\donttest{
# drop the first row and first column because of divergence on Laplace Transform
x = seq(0, 2, length.out=50)[2:50]; y = seq(0, 2, length.out=50)[2:50];
# do kimesurface transform on sine function
z2_grid = kimesurface_transform(FUNCT = function(t) { sin(t) },
                                real_x = x, img_y = y)
                                
time_points = seq(0+0.001, 2*pi, length.out = 160)
inv_data = inv_kimesurface_transform(time_points, z2_grid)
time_Intensities_ILT_df2 <- as.data.frame(cbind(Re=scale(Re(inv_data$Smooth_Reconstruction)), 
                                                Im=scale(Re(inv_data$Raw_Reconstruction)),
                                                fMRI=scale(Re(sin(time_points))),
                                                time_points=time_points))
colnames(time_Intensities_ILT_df2) = c("Smooth Reconstruction", 
                                       "Raw Reconstruction", 
                                       "Original sin()",
                                       "time_points")
df = reshape2::melt(time_Intensities_ILT_df2, id.var = "time_points")
ggplot(df, aes(x = time_points, y = value, colour = variable)) + 
       geom_line(linetype=1, lwd=3) +
       ylab("Function Intensity") + xlab("Time") +
       theme(legend.position="top")+
       labs(title= bquote("Comparison between" ~ "f(t)=sin(t)" ~ "
       and Smooth(ILT(LT(fMRI)))(t); Range [" ~ 0 ~":"~ 2*pi~"]"))
}
}
\author{
SOCR team <\url{http://socr.umich.edu/people/}>
}
