% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flr2taf.R
\name{flr2taf}
\alias{flr2taf}
\title{Convert FLR Table to TAF Format}
\usage{
flr2taf(x, colname = "Value")
}
\arguments{
\item{x}{a table of class \code{FLQuant}.}

\item{colname}{a column name to use if the FLR table contains only one row.}
}
\value{
A data frame in TAF format.
}
\description{
Convert a table from FLR format to TAF format.
}
\note{
FLR uses the \code{FLQuant} class to store tables as 6-dimensional arrays,
while TAF tables are stored as data frames with a year column.
}
\examples{
x <- array(t(catage.xtab), dim=c(4,8,1,1,1,1))
dimnames(x) <- list(age=1:4, year=1963:1970,
                    unit="unique", season="all", area="unique", iter=1)
flr2taf(x)

x1 <- x[1,,,,,,drop=FALSE]
flr2taf(x1)
flr2taf(x1, "Juveniles")

}
\seealso{
\code{\link{catage.taf}} describes the TAF format.

\code{\link{as.data.frame}} is a method provided by the \pkg{FLCore} package
to convert \code{FLQuant} tables to a 7-column long format.

\code{\link{TAF-package}} gives an overview of the package.
}
