% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features_01_claim_occurrence.R
\name{claim_frequency}
\alias{claim_frequency}
\title{Claim Frequency}
\usage{
claim_frequency(I = 40, E = 12000, freq = 0.03, cdf, range, ...)
}
\arguments{
\item{I}{number of claims development periods considered.}

\item{E}{\strong{effective annual} exposure associated with each period (vector).}

\item{freq}{expected frequency per unit exposure for each period (vector).}

\item{cdf}{optional cumulative distribution function to be sampled from.}

\item{range}{support of the custom \code{cdf}, with default (-1e200, 1e200).}

\item{...}{other arguments/parameters to be passed onto \code{cdf}.}
}
\description{
Returns the number of insurance claims occurring in each of the periods.
}
\details{
Unless otherwise specified, \code{claim_frequency()} assumes the
claim frequency follows a Poisson distribution with mean equal to the
product of exposure \code{E} associated with period \eqn{i} and expected
claim frequency \code{freq} per unit exposure for that period. \cr \cr
If no arguments are provided, by default \code{claim_frequency()} assumes
a total of 40 development periods, constant exposure rate at 12000 per year
and constant frequency at 0.03 per unit of exposure. \cr \cr
Pre-defined distribution functions such as \code{ppois} are supported.
}
\examples{
no_period <- 40
exposure <- c(rep(12000, no_period))
exp_freq <- c(rep(0.03, no_period))
# returns the same result as claim_frequency()
claim_frequency(I = no_period, E = exposure, freq = exp_freq)

# some custom pre-defined distribution function
claim_frequency(I = 10, cdf = ppois, range = c(0, 1000), lambda = 80)
}
