% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/course_conversions.R
\name{course_convert_helper}
\alias{course_convert_helper}
\title{Swimming Course Convertor Helper}
\usage{
course_convert_helper(time, event, course, course_to, verbose = FALSE)
}
\arguments{
\item{time}{A time, or vector of times to convert.  Can be in either seconds
(numeric, \code{95.97}) format or swim (character, \code{"1:35.97"}) format}

\item{event}{The event swum as \code{"100 Fly"}, \code{"200 IM"}, \code{"400
Free"}, \code{"50 Back"}, \code{"200 Breast"} etc.}

\item{course}{The course in which the time was swum as \code{"LCM"},
\code{"SCM"} or \code{"SCY"}}

\item{course_to}{The course to convert the time to as \code{"LCM"},
\code{"SCM"} or \code{"SCY"}}

\item{verbose}{If \code{TRUE} will return a data frame containing columns \itemize{ \item
Time \item Course \item Course_To \item Event \item Time_Converted_sec
\item Time_Converted_mmss }.  If \code{FALSE} (the default) will return only a converted time.}
}
\value{
returns the \code{time} for a specified \code{event} and
  \code{course} converted to a time for the specified \code{course_to} in
  swimming format OR a data frame containing columns \itemize{ \item
  Time \item Course \item Course_To \item Event \item Time_Converted_sec
  \item Time_Converted_mmss } depending on the value of \code{verbose}
}
\description{
Used to convert times between Long Course Meters, Short Course Meters and
Short Course Yards
}
\seealso{
\code{course_convert_helper} is a helper function inside \code{\link{course_convert}}
}
