% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boosting_function.R
\name{modelfit.boosting}
\alias{modelfit.boosting}
\title{Boosting model fit function}
\usage{
modelfit.boosting(x, all_beta = NULL)
}
\arguments{
\item{x}{output from boosting_core function.}

\item{all_beta}{default value is FALSE. If this is set to TRUE the 
coefficient estimates for all the parameters will be printed.}
}
\description{
This function provides details of the model fit from the boosting_core
function.
}
\examples{
data <- simulate_survival_cox(true_beta=c(1,1,1,1,1,0,0,0,0,0))
formula <- as.formula("Surv(time,delta) ~ strata(strata_idx) + V1 + V2 + 
V3 + V4 + V5 + V6 + V7 + V8 + V9 + V10" )
boosting.output <- boosting_core(formula, data, rate=0.1, control=500)
modelfit.boosting(boosting.output)

}
\keyword{boosting}
\keyword{gradient}
