% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SIFA.R
\name{SIFA}
\alias{SIFA}
\title{Supervised Integrated Factor Analysis}
\usage{
SIFA(X, Y, r0, r, relation = "linear", sparsity = 0,
  max_niter = 1000, convg_thres = 0.01, type = "Anp")
}
\arguments{
\item{X}{n*q matrix, centered covariate data}

\item{Y}{1*K cell array, each cell is a n*pi centered primary
data, should roughly contribute equally to joint struct}

\item{r0}{scalar, prespecified rank of common structure}

\item{r}{1*K vector, prespecified rank of specific structures}

\item{relation}{'linear' (default), use linear function to model
   the relation between U and covariates
'univ_kernel', use kernel methods for single covariates}

\item{sparsity}{1 (default), when est B0 or B, use LASSO with BIC
to select the best tuning, suitable for high}

\item{max_niter}{default 1000, max number of iteration}

\item{convg_thres}{default 0.01, overall convergence threshold}

\item{type}{"A" or "Anp" or "B" or "Bnp", condition to use}
}
\value{
list with components
\item{B0:}{q*r0 matrix, coefficient for joint structure (may be sparse)}
\item{B:}{1*K cell array, each is a q*ri coefficient matrix (may be sparse)}
\item{V_joint:}{sum(p)*r0 matrix, stacked joint loadings, with orthonormal
                  columns.}

\item{V_ind:}{1*K array, each is a pi*ri loading matrix, with
                  orthonormal columns}
\item{se2:}{1*K vector, noise variance for each phenotypic data set}
\item{Sf0:}{r0*r0 matrix, diagonal covariance matrix}
\item{Sf:}{1*K array, each is a ri*ri diagonal covariance matrix}
\item{EU:}{n*(r0+sum(ri)) matrix, conditional expectation of joint and individual scores}
}
\description{
Supervised Integrated Factor Analysis
}
\examples{
\dontrun{
r0 <- 2
r <- c(3,3)
V <- matrix(stats::rnorm(10*2),10,2)
Fmatrix <- matrix(MASS::mvrnorm(n=2*500,rep(0,2),matrix(c(9,0,0,4),2,2)),500,2)
E <- matrix(stats::rnorm(500*10,0,3),500,10)
X <- tcrossprod(Fmatrix,V)+E
X <-scale(X,center=TRUE,scale=FALSE)
Y1 <- matrix(stats::rnorm(500*200,0,1),500,200)
Y2 <- matrix(stats::rnorm(500*200,0,1),500,200)
Y <- list(Y1,Y2)
SIFA(X,Y,r0,r,max_niter=200)
}
}
