% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geocode-utils.r
\name{validate_geocode}
\alias{validate_geocode}
\alias{is_valid_geocode}
\alias{length_geocode}
\alias{na_geocode}
\title{Validate a geocode}
\usage{
validate_geocode(geocode)

is_valid_geocode(geocode)

length_geocode(geocode)

na_geocode()
}
\arguments{
\item{geocode}{data.frame with geocode data in columns \code{"lat"},
\code{"lon"}, and possibly also \code{"address"}.}
}
\value{
A valid geocode stored in a tibble.

FALSE for invalid, TRUE for valid.

FALSE for invalid, number of rows for valid.

A geo_code tibble with all fields set to suitable NAs.
}
\description{
Test validity of a geocode or ensure that a geocode is valid.
}
\details{
\code{validate_geocode} Converts to tibble, checks data bounds, converts
address to character if it is not already a character vector, or add
character NAs if the address column is missing.

\code{is_valid_geocode} Checks if a geocode is valid, returning 0L if not,
and the number of row otherwise.
}
\examples{

validate_geocode(NA)
validate_geocode(data.frame(lon = -25, lat = 66))

is_valid_geocode(NA)
is_valid_geocode(1L)
is_valid_geocode(data.frame(lon = -25, lat = 66))

na_geocode()

}
