% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/litholog.R
\name{litholog}
\alias{litholog}
\title{Creates a litholog}
\usage{
litholog(l, r, h, i)
}
\arguments{
\item{l, r}{the height of each delimitation (upper and lower; l and r
stand for left and right boundaries of the interval, their order does not
matter)}

\item{h}{the hardness of each bed}

\item{i}{the id of each bed: it should be different for each bed}
}
\value{
A table of depth (dt) and xy value (i.e. hardness, or simply the x
position if your litholog is vertical) of rectangles for each bed. Each bed
is defined by an id (or name), which is the variable i in the table.
}
\description{
Creates basic coordinates of polygons to draw a simple litholog
with rectangles
}
\examples{
l <- c(1,2,3)  # left boundary of the bed interval (upper or lower)
r <- c(0,1,2)  # right boundary of the bed interval (upper or lower)
h  <- c(4,3,4) # hardness (arbitrary)
i   <- c("B1","B2","B3") # Bed name

basic.litholog <- litholog(l,r,h,i) # Generate data frame of the polygons
                                    # making the litholog

whiteSet(xlim = c(0,4), ylim = c(0,3), ytick = 1, ny = 10) # Plot background
multigons(basic.litholog$i, basic.litholog$xy, basic.litholog$dt) # Draw log

}
\seealso{
For a more detailed explanation of how to make a litholog:
\code{\link{StratigrapheR}}

How to prepare the plot background for the litholog: \code{\link{whiteSet}}

How to draw the litholog: \code{\link{multigons}}

How to add the names of the beds in the litholog: \code{\link{bedtext}}

How to plot in pdf: \code{\link{pdfDisplay}}

To add personalised boundaries between beds: \code{\link{weldlog}}

To have open beds at the extremities of the log. More generaly to transform a
polygon into a polyline and control the part that is not drawn:
\code{\link{multilines}} and \code{\link{shift}}

To add details and drawings: \code{\link{centresvg}} and
\code{\link{framesvg}}

Go further with interval data (between two boundaries, as there often is
in stratigraphy): \code{\link{as.lim}} and related functions.

Complementary functions: \code{\link{infobar}} and \code{\link{ylink}}
}
