% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infobar.R
\name{infobar}
\alias{infobar}
\title{Draws rectangles with text in them}
\usage{
infobar(
  xmin,
  xmax,
  ymax,
  ymin,
  labels = NA,
  m = list(),
  t = list(),
  srt = 90,
  family = par("family"),
  xpd = par("xpd")
)
}
\arguments{
\item{xmin, xmax, ymin, ymax}{x and y limits for the rectangles. You can
either provide 1 or n of each (if you want to have always the same x limits
but multiple and different y ones it is possible)}

\item{labels}{a 1 or n character vector (i.e. text) specifying the
text to be written in the rectangle. You can write "" for no text.}

\item{m, t}{a list graphical parameters (of length 1 or n) to feed
multigons() for m and to text() for t. See respective help pages ?multigons
and ?text for the possible arguments. See the example for illustration, and
?merge_list for further information.}

\item{srt, family, xpd}{further graphical parameters, see ?par for information}
}
\description{
Draws rectangles with text in them, typically to delimit
(stratigraphical) intervals (e.g. magnotochrons, but also
lithostratigraphy,...)
}
\examples{
labels <- c("High 5", "Low 5", "5")
ymin <- c(10,-10,2.5)
ymax <- c(20,0, 7.5)

plot(c(0,6),c(-20,20), type = "n")

infobar(xmin = 0, xmax = 1, ymin = ymin, ymax = ymax, labels,
        m = list(col = c("grey","grey", "red"),
                 border = "black", density = 10),
        t = list(cex = 1.5, col = "white"))

}
\seealso{
Similar functions: \code{\link{multigons}}, \code{\link{bedtext}},
\code{\link{nlegend}} and \code{\link{ylink}}

To deal with intervals: \code{\link{as.lim}} and related functions
}
