% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_methods-PLOT.R
\docType{methods}
\name{plot}
\alias{plot}
\alias{plot,Strategy,missing-method}
\title{Plot of a \code{Strategy}-object}
\usage{
\S4method{plot}{Strategy,missing}(x, y, from=NULL, until=NULL
       , which.assets=NULL, which.filters=NULL, which.indicators=NULL
       , main=NULL, show.signals=TRUE, include.costs=TRUE, ...)
}
\arguments{
\item{x}{An object of class \code{Strategy}.}

\item{y}{Standard plot argument that is not relevant for Strategy objects!}

\item{from}{From date that chart is to be plotted.}

\item{until}{Until date that chart is to be plotted.}

\item{which.assets}{Which assets shall be plotted (each one will result in single plot)}

\item{which.filters}{Which filters shall be added to price plot. Default value \code{NULL} will return all filters from the strategy.}

\item{which.indicators}{Which indicators shall be added to indicator plot. Default value \code{NULL} will return all filters from the strategy. If \code{"none"}, no indicator is plotted and indicator area is not shown.}

\item{main}{The main title of the plot.}

\item{show.signals}{If \code{TRUE}, the trading signals are shown within the indicators area of the plot. Default value is \code{TRUE}.}

\item{include.costs}{If \code{FALSE}, the fixed and relative trading costs are NOT considered for performance calculation. Default value is \code{TRUE}. As default values for costs are \code{0}, this argument is redundant if no costs are given.}

\item{...}{Further arguments passed to custom plotFUN (if available) of the object (x).}
}
\description{
Calls a generic \code{plot} function that can plot the data of any \code{Strategy}-object. If a \code{plotFUN}-function is given within the object, this user-defined function will be used. The generic function plots 3 parts:
\itemize{
   \item{Price area} Plots the asset price data and filters.
   \item{Indicator area} Plots the indicators and trading signals.
   \item{Performance area} Plots performance of the strategy.
}
}
\examples{
##Not run:

# MA(200)-Strategy
params <- list(k=200)
myStrat.MA <- Strategy(assets=assets, strat="MA", strat.params=params)

# Plot first asset of MA(200)-Strategy
plot(myStrat.MA, from="2015-01-01", until="2015-12-31", which.assets=1)

##End(Not run)
}

