% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stasis_sl.R
\name{stasis_sl}
\alias{stasis_sl}
\title{simulate phenotypic stasis (specimen level)}
\usage{
stasis_sl(t, mean = 0, sd = 1, intrapop_var = 1, n_per_sample = 10)
}
\arguments{
\item{t}{times at which the traits are determined}

\item{mean}{mean trait value}

\item{sd}{strictly positive number, standard deviation of traits around the mean}

\item{intrapop_var}{intrapopulation variance, determines how much specimens from the same population vary}

\item{n_per_sample}{integer, number of specimens sampled per population/sampling locality}
}
\value{
an object of S3 class \code{pre_paleoTS}, inherits from \code{timelist} and \code{list}. The list has two elements: \code{t}, containing a vector of times of sampling, and \code{vals}, a list of trait values of the same length as \code{t}, with element containing trait values of individual specimens.  This object can be transformed using \code{apply_taphonomy}, \code{apply_niche} or \code{time_to_strat}, and then reduced to a \code{paleoTS} object using \code{reduce_to_paleoTS}. This can then be used to test for different modes of evolution.
}
\description{
simulates stasis as independent, normally distributed random variables with mean \code{mean} and standard deviation \code{sd}, draws \code{n_per_sample} samples from each sampling location (population) that have specified variance \code{intrapop_var}
}
\examples{

library("paleoTS")
x = stasis_sl(1:5, mean = 2, sd = 2)
y = reduce_to_paleoTS(x) # turn into paleoTS format
plot(y) # plot using paleoTS package
# see also
#vignette("paleoTS_functionality")
#for details and advanced usage

}
\seealso{
\itemize{
\item \code{\link[=stasis]{stasis()}} for the version that simulates stasis of mean trait values
\item \code{\link[=strict_stasis_sl]{strict_stasis_sl()}} for more narrow definition of stasis
\item \code{\link[=reduce_to_paleoTS]{reduce_to_paleoTS()}} to transform into the outputs into \code{paleoTS} format (e.g., for plotting or further analysis)
\item \code{\link[=random_walk_sl]{random_walk_sl()}} and \code{\link[=ornstein_uhlenbeck_sl]{ornstein_uhlenbeck_sl()}} for other modes of evolution
}
}
