% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vote.R
\name{vote}
\alias{vote}
\title{Vote for all models}
\usage{
vote(x, ...)
}
\arguments{
\item{x}{each dataframe from outputlist}

\item{...}{further parameters}
}
\value{
A dataframe with column names "model" and combinations of strategy and metric. 
The first column represents the model formula, and a checkmark indicates 
that the corresponding model was supported by the given strategy and metric 
combination. Please note that for the subset strategy, the "vote" will report
the single best model across all numbers of variables under Information 
Criteria (IC). However, this rule should not be applied to Significance Level
(SL) because the F/Rao value is only comparable for models with the same 
number of variables.
}
\description{
Votes for all models across all combinations of strategies and metrics
}
\examples{
data(mtcars)
formula <- mpg ~ .
x <- stepwise(formula = formula,
              data = mtcars,
              type = "linear",
              strategy = c("forward","backward","subset"),
              metric = c("AIC","BIC"))
vote(x)

}
