\name{internals}
\alias{internals}

\alias{assert.is}
\alias{assert.are}
\alias{is.err}

\alias{estimated.LFDR}
\alias{estimated.BFDR}
\alias{BFDR}
\alias{posteriorP0}
 
\alias{is.prob-methods}
\alias{is.prob,ANY-method}
\alias{is.prob,est.lfdr.pvalue-method}

\alias{xprnSetPair-methods}
\alias{xprnSetPair,all.matrixORnumeric,all.matrixORnumeric,missing-method}
\alias{xprnSetPair,ANY,ANY,ANY-method}
\alias{xprnSetPair,xprnSet,missing,character-method}
\alias{xprnSetPair,xprnSet,xprnSet,missing-method}
\alias{xprnSetPair,XprnSet,XprnSet,missing-method}

\alias{xprnSet-methods}
\alias{xprnSet,all.matrixORnumeric,missingOrNULL,missingOrNULL-method}
\alias{xprnSet,all.pfdata,all.matrixORnumeric,all.pfdata-method}
\alias{xprnSet,AnnotatedDataFrame,matrix,AnnotatedDataFrame-method}
\alias{xprnSet,AnnotatedDataFrame,matrix,missing-method}
\alias{xprnSet,ANY,ANY,ANY-method}
\alias{xprnSet,data.frame,matrix,missing-method}
\alias{xprnSet,missing,matrix,missing-method}
\alias{xprnSet,missing,numeric,missing-method}
\alias{xprnSet,missing,xprnSet,missing-method}

\alias{XprnSet-methods}
\alias{XprnSet,all.matrixORnumeric,missingOrNULL,missingOrNULL-method}
\alias{XprnSet,all.pfdata,all.matrixORnumeric,all.pfdata-method}
\alias{XprnSet,ANY,ANY,ANY-method}

\alias{[-methods}
\alias{[,basicFdr,ANY,missing,ANY-method}
\alias{[,bFdr,ANY,missing,ANY-method}
\alias{[,bias.corrected.certainty,ANY,missing,ANY-method}
\alias{[,bias.corrected.pvalue,ANY,missing,ANY-method}
\alias{[,bias.corrected.zvalue,ANY,missing,ANY-method}
\alias{[,biasEstimate,ANY,missing,ANY-method}
\alias{[,cvalue,ANY,missing,ANY-method}
\alias{[,cvalues,ANY,missing,ANY-method}
\alias{[,eFdr,ANY,missing,ANY-method}
\alias{[,error,ANY,missing,ANY-method}
\alias{[,errorPairs,ANY,missing,ANY-method}
\alias{[,est.lfdr.pvalue,ANY,missing,ANY-method}
\alias{[,estimate,ANY,missing,ANY-method}
\alias{[,inverseCDFs,ANY,missing,ANY-method}
\alias{[,loss,ANY,missing,ANY-method}
\alias{[,Matrix,ANY,ANY,ANY-method}
\alias{[,Matrix,ANY,missing,ANY-method}
\alias{[,Matrix,missing,ANY,ANY-method}
\alias{[,Numeric,ANY,missing,ANY-method}
\alias{[,pNumeric,ANY,missing,ANY-method}
\alias{[,posteriorInterval,ANY,missing,ANY-method}
\alias{[,posteriorIntervalPlus,ANY,missing,ANY-method}
\alias{[,posteriorP0.error,ANY,missing,ANY-method}
\alias{[,predictionError,ANY,missing,ANY-method}
\alias{[,Prob0,ANY,missing,ANY-method}
\alias{[,probabilisticRisks,ANY,missing,ANY-method}
\alias{[,pseudoFdr,ANY,missing,ANY-method}
\alias{[,sFdr,ANY,missing,ANY-method}
\alias{[,sim.biasEstimates,ANY,ANY,missing-method}
\alias{[,sortableEstimate,ANY,missing,ANY-method}
\alias{[,statistic.cvalue,ANY,missing,ANY-method}
\alias{[,ttest,ANY,missing,ANY-method}
\alias{[,unsortableEstimate,ANY,missing,ANY-method}
\alias{[,xprnSet,ANY,ANY,ANY-method}
\alias{[,xprnSet,ANY,missing,ANY-method}
\alias{[,xprnSet,missing,ANY,ANY-method}
\alias{[,xprnSetPair,ANY,missing,ANY-method}
        
\alias{[<--methods}
\alias{[<-,Matrix,ANY,missing-method}
\alias{[<-,Numeric,ANY,missing-method}
\alias{[<-,pNumeric,ANY,missing-method}

\alias{sqrt-methods}
\alias{sqrt,error-method}
\alias{sqrt,errorPair-method}
\alias{sqrt,errorPairs-method}
\alias{sqrt,Numeric-method}

\alias{rownames-methods}
\alias{rownames,d1classx-method}
\alias{rownames,prnSet-method}
\alias{rownames,prnSetPair-method}

\alias{names-methods}
\alias{names,basicFdr-method}
\alias{names,bFdr-method}
\alias{names,biasEstimate-method}
\alias{names,CI-method}
\alias{names,cvalue-method}
\alias{names,eFdr-method}
\alias{names,empiricalNull-method}
\alias{names,est.lfdr.pvalue-method}
\alias{names,estimate-method}
\alias{names,lik.ratios-method}
\alias{names,pointEstimate-method}
\alias{names,posteriorInterval-method}
\alias{names,posteriorP0-method}
\alias{names,Prob0-method}
\alias{names,pseudoFdr-method}
\alias{names,sFdr-method}
\alias{names,ttest-method}
\alias{names,xprnSet-method}
\alias{names,xprnSetPair-method}

\alias{names<--methods}
\alias{names<-,est.lfdr.pvalue,character-method}

\alias{length-methods}
\alias{length,basicFdr-method}
\alias{length,bFdr-method}
\alias{length,bias.corrected.certainty-method}
\alias{length,binomMetalevel-method}
\alias{length,cvalue-method}
\alias{length,eFdr-method}
\alias{length,empiricalNull-method}
\alias{length,est.lfdr.pvalue-method}
\alias{length,pointEstimate-method}
\alias{length,posteriorInterval-method}
\alias{length,probabilisticRisk-method}
\alias{length,pseudoFdr-method}
\alias{length,riskPair-method}
\alias{length,sFdr-method}
\alias{length,ttest-method}
\alias{length,xprnSet-method}

\alias{log-methods}
\alias{log,ExpressionSet-method}
\alias{log2-methods}
\alias{log2,ExpressionSet-method}
\alias{logb-methods}
\alias{logb,ANY,ANY-method}
\alias{logb,ExpressionSet,ANY-method}
\alias{logb,ExpressionSet,missing-method}
\alias{logb,XprnSet,ANY-method}
\alias{logb,xprnSet,missing-method}
\alias{logb,XprnSet,missing-method}
\alias{logb,xprnSetPair,missing-method}

\alias{median-methods}
\alias{median,ANY,ANY-method}
\alias{median,inverseCDFs,missing-method}

\alias{mean-methods}
\alias{mean,error-method}
\alias{mean,nonparametricBootstrap-method}
\alias{mean,posteriorP0.error-method}
\alias{mean,resampled.posteriorP0-method}
\alias{mean,xprnSet-method}
\alias{mean,XprnSet-method}

\alias{hist-methods}
\alias{hist,ANY-method}
\alias{hist,errorPair-method}
\alias{hist,posteriorIntervalPlus-method}
\alias{hist,sim.biasEstimates-method}
\alias{hist,xprnSet-method}

\alias{fData-methods}
\alias{fData,prnSet-method}
\alias{fData,prnSetPair-method}
\alias{fData<--methods}
\alias{fData<-,prnSet,ANY-method}

\alias{annotation-methods}
\alias{annotation,ANY-method}
\alias{annotation,basicFdr-method}
\alias{annotation,bFdr-method}
\alias{annotation,biasEstimate-method}
\alias{annotation,biasEstimates-method}
\alias{annotation,eFdr-method}
\alias{annotation,errorPair-method}
\alias{annotation,Estimator-method}
\alias{annotation,loss-method}
\alias{annotation,prnSetPair-method}
\alias{annotation,Prob0-method}
\alias{annotation,probabilisticRisk-method}
\alias{annotation,probabilisticRisks-method}
\alias{annotation,ProbabilityEstimate-method}
\alias{annotation,pseudoFdr-method}
\alias{annotation,sFdr-method}
\alias{annotation,unsortableEstimate-method}
\alias{annotation,xprnSet-method}
\alias{annotation<--methods}
\alias{annotation<-,prnSet,ANY-method}
\alias{annotation<-,prnSetPair,ANY-method}

\alias{pData-methods}
\alias{pData,prnSet-method}
\alias{pData,prnSetPair-method}
\alias{pData,xprnSet-method}
\alias{pData<--methods}
\alias{pData<-,prnSet,ANY-method}

\alias{exprs-methods}
\alias{exprs,prnSetPair-method}
\alias{exprs,xprnSet-method}
\alias{exprs,XprnSet-method}

\alias{exp-methods}
\alias{exp,ExpressionSet-method}
\alias{exp,xprnSet-method}

\alias{dimnames-methods}
\alias{dimnames,xprnSet-method}
\alias{dim-methods}
\alias{dim,xprnSet-method}

\alias{as.numeric-methods}
\alias{as.numeric,est.lfdr.pvalue-method}

\alias{colnames-methods}
\alias{colnames,d1classx-method}
\alias{colnames,prnSet-method}
\alias{colnames,prnSetPair-method}
\alias{colnames<--methods}
\alias{colnames<-,d1classx,d1classx-method}

\alias{featureNames-methods}
\alias{featureNames,xprnSet-method}
\alias{featureNames,xprnSetObjectPair-method}
\alias{featureNames,xprnSetPair-method}

\alias{nrow-methods}
\alias{nrow,d1classx-method}
\alias{nrow,NULL-method}
\alias{nrow,prnSet-method}
\alias{nrow,prnSetPair-method}
\alias{ncol-methods}
\alias{ncol,d1classx-method}
\alias{ncol,NULL-method}
\alias{ncol,prnSet-method}
\alias{ncol,prnSetPair-method}

\alias{nplot-methods}
\alias{nplot,ANY,ANY-method}
\alias{nplot,est.lfdr.pvalue,missing-method}
\alias{nplot,list,missing-method}

\alias{mylocfdr}
\alias{myzsim}
\alias{myalpha}

\alias{new.est.lfdr.pvalue}
\alias{uniquex}
\alias{list2est}
\alias{est2list}
\alias{get.args}
\alias{data2statANDpvalue}
\alias{stat.toANDfrom.pvalue}
\alias{MakeNames}
\alias{get.other.from.testfun}
\alias{get.pvalues}
\alias{get.stats}
\alias{stat2pval}
\alias{pval2stat}
\alias{is.error}

\alias{is.prob}
\alias{nplot}


\title{Internal Functions and Methods}
\description{
  These functions are for internal use only or not yet documented. They are
  methods for classes \code{xprnSet}, \code{XprnSet}, \code{xprnSetPair}.
}



\usage{
 xprnSet(phenoData, exprs, featureData, ...)
 XprnSet(phenoData, exprs, featureData, ...)
 xprnSetPair(x, y, factor.name, ...)
exprs(object)
pData(object)
pData(object) <- value
fData(object)
fData(object) <- value
featureNames(object)
annotation(object,...)
annotation(object,...) <- value
nplot(x,y,...)
median(x, na.rm = FALSE)
hist(x,...)
logb(x,base)
myzsim(alpha,N,n,stand,J)
myalpha(dat,samp,start,n,perm,sw)
mylocfdr(zz,p.value,nulltype, ...)

new.est.lfdr.pvalue(LFDR.hat,p0.hat,pvalue,method=NULL,info=list())
uniquex(x,y=NULL,vip=1)
list2est(x,n.object)
est2list(x)
get.args(fun,max.size=c(1,3),n=1,wn=-1,...)
data2statANDpvalue(x,y=NULL,fun=abs.t.test,paired=FALSE,
  opt=c('both','all','b','a','pvalue','p','stat','s'),...)
stat.toANDfrom.pvalue(stat=NULL,pvalue=NULL,cFUN,alternative="two.sided",
  sym.distrib=T,...)
get.other.from.testfun(x,y=NULL,fun=t.test,paired=FALSE,opt='parameter',...)
get.pvalues(x,y=NULL,fun=t.test,paired=FALSE,...)
get.stats(x,y=NULL,fun=t.test,paired=FALSE,...)
stat2pval(x,pFUN=pt,sym.distrib=T,alternative='two.sided',...)
pval2stat(x,qFUN=qt,alternative='two.sided',...)
MakeNames(x,nmvar=c('X','I'),...)
is.error(object)
assert.is(object, class2, text = "")
assert.are(object, class2, ...)
is.prob(P, tolerance = 1e-3, ...)
is.err(object)
estimated.LFDR(object, monotonic = FALSE, p = numeric(0), save.time = FALSE,
  verbose = FALSE, ties.method = "random", achieved.BFDR.fun = estimated.BFDR, ...)
estimated.BFDR(object, alpha, nfeature, P0 = 1, p = numeric(0), n = numeric(0),
  ndiscovery.correction = 0, correct, verbose = FALSE, ...) 
posteriorP0(distr0 = NULL, fam = NULL, x, verbose = FALSE, individual, confidence,
  unknown.param = NULL, save.time = logical(0), ...) 
BFDR(alpha, P0 = 1, prob.discovery, size)

}

\keyword{internal}

