// Generated by rstantools.  Do not edit by hand.

/*
    StanMoMo is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    StanMoMo is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with StanMoMo.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_APCmodel_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_APCmodel");
    reader.add_event(137, 135, "end", "model_APCmodel");
    return reader;
}
#include <stan_meta_header.hpp>
class model_APCmodel
  : public stan::model::model_base_crtp<model_APCmodel> {
private:
        int J;
        int T;
        std::vector<int> d;
        vector_d e;
        int Tfor;
        int Tval;
        std::vector<int> dval;
        vector_d eval;
        int family;
        vector_d offset;
        vector_d offset2;
        int C;
        int L;
public:
    model_APCmodel(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_APCmodel(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_APCmodel_namespace::model_APCmodel";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 4;
            context__.validate_dims("data initialization", "J", "int", context__.to_vec());
            J = int(0);
            vals_i__ = context__.vals_i("J");
            pos__ = 0;
            J = vals_i__[pos__++];
            check_greater_or_equal(function__, "J", J, 1);
            current_statement_begin__ = 5;
            context__.validate_dims("data initialization", "T", "int", context__.to_vec());
            T = int(0);
            vals_i__ = context__.vals_i("T");
            pos__ = 0;
            T = vals_i__[pos__++];
            check_greater_or_equal(function__, "T", T, 1);
            current_statement_begin__ = 6;
            validate_non_negative_index("d", "(J * T)", (J * T));
            context__.validate_dims("data initialization", "d", "int", context__.to_vec((J * T)));
            d = std::vector<int>((J * T), int(0));
            vals_i__ = context__.vals_i("d");
            pos__ = 0;
            size_t d_k_0_max__ = (J * T);
            for (size_t k_0__ = 0; k_0__ < d_k_0_max__; ++k_0__) {
                d[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 7;
            validate_non_negative_index("e", "(J * T)", (J * T));
            context__.validate_dims("data initialization", "e", "vector_d", context__.to_vec((J * T)));
            e = Eigen::Matrix<double, Eigen::Dynamic, 1>((J * T));
            vals_r__ = context__.vals_r("e");
            pos__ = 0;
            size_t e_j_1_max__ = (J * T);
            for (size_t j_1__ = 0; j_1__ < e_j_1_max__; ++j_1__) {
                e(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 8;
            context__.validate_dims("data initialization", "Tfor", "int", context__.to_vec());
            Tfor = int(0);
            vals_i__ = context__.vals_i("Tfor");
            pos__ = 0;
            Tfor = vals_i__[pos__++];
            check_greater_or_equal(function__, "Tfor", Tfor, 1);
            current_statement_begin__ = 9;
            context__.validate_dims("data initialization", "Tval", "int", context__.to_vec());
            Tval = int(0);
            vals_i__ = context__.vals_i("Tval");
            pos__ = 0;
            Tval = vals_i__[pos__++];
            check_greater_or_equal(function__, "Tval", Tval, 0);
            current_statement_begin__ = 10;
            validate_non_negative_index("dval", "(J * Tval)", (J * Tval));
            context__.validate_dims("data initialization", "dval", "int", context__.to_vec((J * Tval)));
            dval = std::vector<int>((J * Tval), int(0));
            vals_i__ = context__.vals_i("dval");
            pos__ = 0;
            size_t dval_k_0_max__ = (J * Tval);
            for (size_t k_0__ = 0; k_0__ < dval_k_0_max__; ++k_0__) {
                dval[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 11;
            validate_non_negative_index("eval", "(J * Tval)", (J * Tval));
            context__.validate_dims("data initialization", "eval", "vector_d", context__.to_vec((J * Tval)));
            eval = Eigen::Matrix<double, Eigen::Dynamic, 1>((J * Tval));
            vals_r__ = context__.vals_r("eval");
            pos__ = 0;
            size_t eval_j_1_max__ = (J * Tval);
            for (size_t j_1__ = 0; j_1__ < eval_j_1_max__; ++j_1__) {
                eval(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 12;
            context__.validate_dims("data initialization", "family", "int", context__.to_vec());
            family = int(0);
            vals_i__ = context__.vals_i("family");
            pos__ = 0;
            family = vals_i__[pos__++];
            check_greater_or_equal(function__, "family", family, 0);
            check_less_or_equal(function__, "family", family, 1);
            // initialize transformed data variables
            current_statement_begin__ = 15;
            validate_non_negative_index("offset", "(J * T)", (J * T));
            offset = Eigen::Matrix<double, Eigen::Dynamic, 1>((J * T));
            stan::math::fill(offset, DUMMY_VAR__);
            stan::math::assign(offset,stan::math::log(e));
            current_statement_begin__ = 16;
            validate_non_negative_index("offset2", "(J * Tval)", (J * Tval));
            offset2 = Eigen::Matrix<double, Eigen::Dynamic, 1>((J * Tval));
            stan::math::fill(offset2, DUMMY_VAR__);
            stan::math::assign(offset2,stan::math::log(eval));
            current_statement_begin__ = 17;
            C = int(0);
            stan::math::fill(C, std::numeric_limits<int>::min());
            current_statement_begin__ = 18;
            L = int(0);
            stan::math::fill(L, std::numeric_limits<int>::min());
            // execute transformed data statements
            current_statement_begin__ = 19;
            stan::math::assign(C, ((J + T) - 1));
            current_statement_begin__ = 20;
            stan::math::assign(L, (J * Tfor));
            // validate transformed data
            current_statement_begin__ = 17;
            check_greater_or_equal(function__, "C", C, 1);
            current_statement_begin__ = 18;
            check_greater_or_equal(function__, "L", L, 1);
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 23;
            validate_non_negative_index("aux", "logical_gt(family, 0)", logical_gt(family, 0));
            num_params_r__ += (1 * logical_gt(family, 0));
            current_statement_begin__ = 24;
            validate_non_negative_index("a", "J", J);
            num_params_r__ += J;
            current_statement_begin__ = 26;
            num_params_r__ += 1;
            current_statement_begin__ = 27;
            validate_non_negative_index("ks", "(T - 1)", (T - 1));
            num_params_r__ += (T - 1);
            current_statement_begin__ = 29;
            num_params_r__ += 1;
            current_statement_begin__ = 30;
            num_params_r__ += 1;
            current_statement_begin__ = 31;
            validate_non_negative_index("gs", "(C - 2)", (C - 2));
            num_params_r__ += (C - 2);
            current_statement_begin__ = 33;
            validate_non_negative_index("sigma", "2", 2);
            num_params_r__ += (1 * 2);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_APCmodel() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 23;
        if (!(context__.contains_r("aux")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable aux missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("aux");
        pos__ = 0U;
        validate_non_negative_index("aux", "logical_gt(family, 0)", logical_gt(family, 0));
        context__.validate_dims("parameter initialization", "aux", "double", context__.to_vec(logical_gt(family, 0)));
        std::vector<double> aux(logical_gt(family, 0), double(0));
        size_t aux_k_0_max__ = logical_gt(family, 0);
        for (size_t k_0__ = 0; k_0__ < aux_k_0_max__; ++k_0__) {
            aux[k_0__] = vals_r__[pos__++];
        }
        size_t aux_i_0_max__ = logical_gt(family, 0);
        for (size_t i_0__ = 0; i_0__ < aux_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, aux[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable aux: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 24;
        if (!(context__.contains_r("a")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable a missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("a");
        pos__ = 0U;
        validate_non_negative_index("a", "J", J);
        context__.validate_dims("parameter initialization", "a", "vector_d", context__.to_vec(J));
        Eigen::Matrix<double, Eigen::Dynamic, 1> a(J);
        size_t a_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < a_j_1_max__; ++j_1__) {
            a(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(a);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable a: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 26;
        if (!(context__.contains_r("c")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable c missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("c");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "c", "double", context__.to_vec());
        double c(0);
        c = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(c);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable c: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 27;
        if (!(context__.contains_r("ks")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable ks missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("ks");
        pos__ = 0U;
        validate_non_negative_index("ks", "(T - 1)", (T - 1));
        context__.validate_dims("parameter initialization", "ks", "vector_d", context__.to_vec((T - 1)));
        Eigen::Matrix<double, Eigen::Dynamic, 1> ks((T - 1));
        size_t ks_j_1_max__ = (T - 1);
        for (size_t j_1__ = 0; j_1__ < ks_j_1_max__; ++j_1__) {
            ks(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(ks);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable ks: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 29;
        if (!(context__.contains_r("psi")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable psi missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("psi");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "psi", "double", context__.to_vec());
        double psi(0);
        psi = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(psi);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable psi: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 30;
        if (!(context__.contains_r("psi2")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable psi2 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("psi2");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "psi2", "double", context__.to_vec());
        double psi2(0);
        psi2 = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(psi2);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable psi2: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 31;
        if (!(context__.contains_r("gs")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable gs missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("gs");
        pos__ = 0U;
        validate_non_negative_index("gs", "(C - 2)", (C - 2));
        context__.validate_dims("parameter initialization", "gs", "vector_d", context__.to_vec((C - 2)));
        Eigen::Matrix<double, Eigen::Dynamic, 1> gs((C - 2));
        size_t gs_j_1_max__ = (C - 2);
        for (size_t j_1__ = 0; j_1__ < gs_j_1_max__; ++j_1__) {
            gs(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(gs);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable gs: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 33;
        if (!(context__.contains_r("sigma")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        validate_non_negative_index("sigma", "2", 2);
        context__.validate_dims("parameter initialization", "sigma", "double", context__.to_vec(2));
        std::vector<double> sigma(2, double(0));
        size_t sigma_k_0_max__ = 2;
        for (size_t k_0__ = 0; k_0__ < sigma_k_0_max__; ++k_0__) {
            sigma[k_0__] = vals_r__[pos__++];
        }
        size_t sigma_i_0_max__ = 2;
        for (size_t i_0__ = 0; i_0__ < sigma_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, sigma[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 23;
            std::vector<local_scalar_t__> aux;
            size_t aux_d_0_max__ = logical_gt(family, 0);
            aux.reserve(aux_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < aux_d_0_max__; ++d_0__) {
                if (jacobian__)
                    aux.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    aux.push_back(in__.scalar_lb_constrain(0));
            }
            current_statement_begin__ = 24;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> a;
            (void) a;  // dummy to suppress unused var warning
            if (jacobian__)
                a = in__.vector_constrain(J, lp__);
            else
                a = in__.vector_constrain(J);
            current_statement_begin__ = 26;
            local_scalar_t__ c;
            (void) c;  // dummy to suppress unused var warning
            if (jacobian__)
                c = in__.scalar_constrain(lp__);
            else
                c = in__.scalar_constrain();
            current_statement_begin__ = 27;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> ks;
            (void) ks;  // dummy to suppress unused var warning
            if (jacobian__)
                ks = in__.vector_constrain((T - 1), lp__);
            else
                ks = in__.vector_constrain((T - 1));
            current_statement_begin__ = 29;
            local_scalar_t__ psi;
            (void) psi;  // dummy to suppress unused var warning
            if (jacobian__)
                psi = in__.scalar_constrain(lp__);
            else
                psi = in__.scalar_constrain();
            current_statement_begin__ = 30;
            local_scalar_t__ psi2;
            (void) psi2;  // dummy to suppress unused var warning
            if (jacobian__)
                psi2 = in__.scalar_constrain(lp__);
            else
                psi2 = in__.scalar_constrain();
            current_statement_begin__ = 31;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> gs;
            (void) gs;  // dummy to suppress unused var warning
            if (jacobian__)
                gs = in__.vector_constrain((C - 2), lp__);
            else
                gs = in__.vector_constrain((C - 2));
            current_statement_begin__ = 33;
            std::vector<local_scalar_t__> sigma;
            size_t sigma_d_0_max__ = 2;
            sigma.reserve(sigma_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < sigma_d_0_max__; ++d_0__) {
                if (jacobian__)
                    sigma.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    sigma.push_back(in__.scalar_lb_constrain(0));
            }
            // transformed parameters
            current_statement_begin__ = 36;
            validate_non_negative_index("k", "T", T);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> k(T);
            stan::math::initialize(k, DUMMY_VAR__);
            stan::math::fill(k, DUMMY_VAR__);
            current_statement_begin__ = 37;
            validate_non_negative_index("g", "C", C);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> g(C);
            stan::math::initialize(g, DUMMY_VAR__);
            stan::math::fill(g, DUMMY_VAR__);
            current_statement_begin__ = 38;
            local_scalar_t__ phi;
            (void) phi;  // dummy to suppress unused var warning
            stan::math::initialize(phi, DUMMY_VAR__);
            stan::math::fill(phi, DUMMY_VAR__);
            stan::math::assign(phi,stan::math::negative_infinity());
            // transformed parameters block statements
            current_statement_begin__ = 39;
            stan::model::assign(k, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        0, 
                        "assigning variable k");
            current_statement_begin__ = 40;
            stan::model::assign(k, 
                        stan::model::cons_list(stan::model::index_min_max(2, T), stan::model::nil_index_list()), 
                        ks, 
                        "assigning variable k");
            current_statement_begin__ = 41;
            stan::model::assign(g, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        0, 
                        "assigning variable g");
            current_statement_begin__ = 42;
            stan::model::assign(g, 
                        stan::model::cons_list(stan::model::index_min_max(2, (C - 1)), stan::model::nil_index_list()), 
                        gs, 
                        "assigning variable g");
            current_statement_begin__ = 43;
            stan::model::assign(g, 
                        stan::model::cons_list(stan::model::index_uni(C), stan::model::nil_index_list()), 
                        0, 
                        "assigning variable g");
            current_statement_begin__ = 44;
            if (as_bool(logical_gt(family, 0))) {
                current_statement_begin__ = 44;
                stan::math::assign(phi, inv(get_base1(aux, 1, "aux", 1)));
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 36;
            size_t k_j_1_max__ = T;
            for (size_t j_1__ = 0; j_1__ < k_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(k(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: k" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable k: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 37;
            size_t g_j_1_max__ = C;
            for (size_t j_1__ = 0; j_1__ < g_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(g(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: g" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable g: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 38;
            if (stan::math::is_uninitialized(phi)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: phi";
                stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable phi: ") + msg__.str()), current_statement_begin__, prog_reader__());
            }
            // model body
            {
            current_statement_begin__ = 48;
            validate_non_negative_index("mu", "(J * T)", (J * T));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> mu((J * T));
            stan::math::initialize(mu, DUMMY_VAR__);
            stan::math::fill(mu, DUMMY_VAR__);
            current_statement_begin__ = 49;
            int pos(0);
            (void) pos;  // dummy to suppress unused var warning
            stan::math::fill(pos, std::numeric_limits<int>::min());
            stan::math::assign(pos,1);
            current_statement_begin__ = 50;
            for (int t = 1; t <= T; ++t) {
                current_statement_begin__ = 50;
                for (int x = 1; x <= J; ++x) {
                    current_statement_begin__ = 51;
                    stan::model::assign(mu, 
                                stan::model::cons_list(stan::model::index_uni(pos), stan::model::nil_index_list()), 
                                (((get_base1(offset, pos, "offset", 1) + get_base1(a, x, "a", 1)) + get_base1(k, t, "k", 1)) + get_base1(g, ((t - x) + J), "g", 1)), 
                                "assigning variable mu");
                    current_statement_begin__ = 52;
                    stan::math::assign(pos, (pos + 1));
                }
            }
            current_statement_begin__ = 55;
            lp_accum__.add(normal_log(get_base1(ks, 1, "ks", 1), c, get_base1(sigma, 1, "sigma", 1)));
            current_statement_begin__ = 56;
            lp_accum__.add(normal_log(stan::model::rvalue(ks, stan::model::cons_list(stan::model::index_min_max(2, (T - 1)), stan::model::nil_index_list()), "ks"), add(c, stan::model::rvalue(ks, stan::model::cons_list(stan::model::index_min_max(1, (T - 2)), stan::model::nil_index_list()), "ks")), get_base1(sigma, 1, "sigma", 1)));
            current_statement_begin__ = 58;
            lp_accum__.add(normal_log(get_base1(gs, 1, "gs", 1), 0, get_base1(sigma, 2, "sigma", 1)));
            current_statement_begin__ = 59;
            lp_accum__.add(normal_log(get_base1(gs, 2, "gs", 1), (psi * get_base1(gs, 1, "gs", 1)), get_base1(sigma, 2, "sigma", 1)));
            current_statement_begin__ = 60;
            lp_accum__.add(normal_log(stan::model::rvalue(gs, stan::model::cons_list(stan::model::index_min_max(3, (C - 2)), stan::model::nil_index_list()), "gs"), add(multiply(psi, stan::model::rvalue(gs, stan::model::cons_list(stan::model::index_min_max(2, (C - 3)), stan::model::nil_index_list()), "gs")), multiply(psi2, stan::model::rvalue(gs, stan::model::cons_list(stan::model::index_min_max(1, (C - 4)), stan::model::nil_index_list()), "gs"))), get_base1(sigma, 2, "sigma", 1)));
            current_statement_begin__ = 63;
            if (as_bool(logical_eq(family, 0))) {
                current_statement_begin__ = 64;
                lp_accum__.add(poisson_log_log(d, mu));
            } else {
                current_statement_begin__ = 67;
                lp_accum__.add(neg_binomial_2_log_log(d, mu, phi));
            }
            current_statement_begin__ = 70;
            lp_accum__.add(normal_log(a, 0, 10));
            current_statement_begin__ = 71;
            lp_accum__.add(normal_log(psi, 0, stan::math::sqrt(10)));
            current_statement_begin__ = 72;
            lp_accum__.add(normal_log(psi2, 0, stan::math::sqrt(10)));
            current_statement_begin__ = 73;
            lp_accum__.add(normal_log(c, 0, stan::math::sqrt(10)));
            current_statement_begin__ = 74;
            lp_accum__.add(exponential_log(sigma, 0.1));
            current_statement_begin__ = 75;
            if (as_bool(logical_gt(family, 0))) {
                current_statement_begin__ = 75;
                lp_accum__.add((normal_log(aux, 0, 1) - normal_cdf_log(0, 0, 1)));
            }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("aux");
        names__.push_back("a");
        names__.push_back("c");
        names__.push_back("ks");
        names__.push_back("psi");
        names__.push_back("psi2");
        names__.push_back("gs");
        names__.push_back("sigma");
        names__.push_back("k");
        names__.push_back("g");
        names__.push_back("phi");
        names__.push_back("k_p");
        names__.push_back("g_p");
        names__.push_back("gf");
        names__.push_back("mufor");
        names__.push_back("log_lik");
        names__.push_back("log_lik2");
        names__.push_back("pos");
        names__.push_back("pos2");
        names__.push_back("pos3");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(logical_gt(family, 0));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((T - 1));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((C - 2));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(C);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(Tfor);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(Tfor);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((C + Tfor));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(L);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((J * T));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((J * Tval));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_APCmodel_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        std::vector<double> aux;
        size_t aux_d_0_max__ = logical_gt(family, 0);
        aux.reserve(aux_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < aux_d_0_max__; ++d_0__) {
            aux.push_back(in__.scalar_lb_constrain(0));
        }
        size_t aux_k_0_max__ = logical_gt(family, 0);
        for (size_t k_0__ = 0; k_0__ < aux_k_0_max__; ++k_0__) {
            vars__.push_back(aux[k_0__]);
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> a = in__.vector_constrain(J);
        size_t a_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < a_j_1_max__; ++j_1__) {
            vars__.push_back(a(j_1__));
        }
        double c = in__.scalar_constrain();
        vars__.push_back(c);
        Eigen::Matrix<double, Eigen::Dynamic, 1> ks = in__.vector_constrain((T - 1));
        size_t ks_j_1_max__ = (T - 1);
        for (size_t j_1__ = 0; j_1__ < ks_j_1_max__; ++j_1__) {
            vars__.push_back(ks(j_1__));
        }
        double psi = in__.scalar_constrain();
        vars__.push_back(psi);
        double psi2 = in__.scalar_constrain();
        vars__.push_back(psi2);
        Eigen::Matrix<double, Eigen::Dynamic, 1> gs = in__.vector_constrain((C - 2));
        size_t gs_j_1_max__ = (C - 2);
        for (size_t j_1__ = 0; j_1__ < gs_j_1_max__; ++j_1__) {
            vars__.push_back(gs(j_1__));
        }
        std::vector<double> sigma;
        size_t sigma_d_0_max__ = 2;
        sigma.reserve(sigma_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < sigma_d_0_max__; ++d_0__) {
            sigma.push_back(in__.scalar_lb_constrain(0));
        }
        size_t sigma_k_0_max__ = 2;
        for (size_t k_0__ = 0; k_0__ < sigma_k_0_max__; ++k_0__) {
            vars__.push_back(sigma[k_0__]);
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 36;
            validate_non_negative_index("k", "T", T);
            Eigen::Matrix<double, Eigen::Dynamic, 1> k(T);
            stan::math::initialize(k, DUMMY_VAR__);
            stan::math::fill(k, DUMMY_VAR__);
            current_statement_begin__ = 37;
            validate_non_negative_index("g", "C", C);
            Eigen::Matrix<double, Eigen::Dynamic, 1> g(C);
            stan::math::initialize(g, DUMMY_VAR__);
            stan::math::fill(g, DUMMY_VAR__);
            current_statement_begin__ = 38;
            double phi;
            (void) phi;  // dummy to suppress unused var warning
            stan::math::initialize(phi, DUMMY_VAR__);
            stan::math::fill(phi, DUMMY_VAR__);
            stan::math::assign(phi,stan::math::negative_infinity());
            // do transformed parameters statements
            current_statement_begin__ = 39;
            stan::model::assign(k, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        0, 
                        "assigning variable k");
            current_statement_begin__ = 40;
            stan::model::assign(k, 
                        stan::model::cons_list(stan::model::index_min_max(2, T), stan::model::nil_index_list()), 
                        ks, 
                        "assigning variable k");
            current_statement_begin__ = 41;
            stan::model::assign(g, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        0, 
                        "assigning variable g");
            current_statement_begin__ = 42;
            stan::model::assign(g, 
                        stan::model::cons_list(stan::model::index_min_max(2, (C - 1)), stan::model::nil_index_list()), 
                        gs, 
                        "assigning variable g");
            current_statement_begin__ = 43;
            stan::model::assign(g, 
                        stan::model::cons_list(stan::model::index_uni(C), stan::model::nil_index_list()), 
                        0, 
                        "assigning variable g");
            current_statement_begin__ = 44;
            if (as_bool(logical_gt(family, 0))) {
                current_statement_begin__ = 44;
                stan::math::assign(phi, inv(get_base1(aux, 1, "aux", 1)));
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            // write transformed parameters
            if (include_tparams__) {
                size_t k_j_1_max__ = T;
                for (size_t j_1__ = 0; j_1__ < k_j_1_max__; ++j_1__) {
                    vars__.push_back(k(j_1__));
                }
                size_t g_j_1_max__ = C;
                for (size_t j_1__ = 0; j_1__ < g_j_1_max__; ++j_1__) {
                    vars__.push_back(g(j_1__));
                }
                vars__.push_back(phi);
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 79;
            validate_non_negative_index("k_p", "Tfor", Tfor);
            Eigen::Matrix<double, Eigen::Dynamic, 1> k_p(Tfor);
            stan::math::initialize(k_p, DUMMY_VAR__);
            stan::math::fill(k_p, DUMMY_VAR__);
            current_statement_begin__ = 80;
            validate_non_negative_index("g_p", "Tfor", Tfor);
            Eigen::Matrix<double, Eigen::Dynamic, 1> g_p(Tfor);
            stan::math::initialize(g_p, DUMMY_VAR__);
            stan::math::fill(g_p, DUMMY_VAR__);
            current_statement_begin__ = 81;
            validate_non_negative_index("gf", "(C + Tfor)", (C + Tfor));
            Eigen::Matrix<double, Eigen::Dynamic, 1> gf((C + Tfor));
            stan::math::initialize(gf, DUMMY_VAR__);
            stan::math::fill(gf, DUMMY_VAR__);
            current_statement_begin__ = 82;
            validate_non_negative_index("mufor", "L", L);
            Eigen::Matrix<double, Eigen::Dynamic, 1> mufor(L);
            stan::math::initialize(mufor, DUMMY_VAR__);
            stan::math::fill(mufor, DUMMY_VAR__);
            current_statement_begin__ = 83;
            validate_non_negative_index("log_lik", "(J * T)", (J * T));
            Eigen::Matrix<double, Eigen::Dynamic, 1> log_lik((J * T));
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik, DUMMY_VAR__);
            current_statement_begin__ = 84;
            validate_non_negative_index("log_lik2", "(J * Tval)", (J * Tval));
            Eigen::Matrix<double, Eigen::Dynamic, 1> log_lik2((J * Tval));
            stan::math::initialize(log_lik2, DUMMY_VAR__);
            stan::math::fill(log_lik2, DUMMY_VAR__);
            current_statement_begin__ = 85;
            int pos;
            (void) pos;  // dummy to suppress unused var warning
            stan::math::fill(pos, std::numeric_limits<int>::min());
            stan::math::assign(pos,1);
            current_statement_begin__ = 86;
            int pos2;
            (void) pos2;  // dummy to suppress unused var warning
            stan::math::fill(pos2, std::numeric_limits<int>::min());
            stan::math::assign(pos2,1);
            current_statement_begin__ = 87;
            int pos3;
            (void) pos3;  // dummy to suppress unused var warning
            stan::math::fill(pos3, std::numeric_limits<int>::min());
            stan::math::assign(pos3,1);
            // generated quantities statements
            current_statement_begin__ = 89;
            stan::model::assign(k_p, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        ((c + get_base1(k, T, "k", 1)) + (get_base1(sigma, 1, "sigma", 1) * normal_rng(0, 1, base_rng__))), 
                        "assigning variable k_p");
            current_statement_begin__ = 90;
            for (int t = 2; t <= Tfor; ++t) {
                current_statement_begin__ = 90;
                stan::model::assign(k_p, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            ((c + get_base1(k_p, (t - 1), "k_p", 1)) + (get_base1(sigma, 1, "sigma", 1) * normal_rng(0, 1, base_rng__))), 
                            "assigning variable k_p");
            }
            current_statement_begin__ = 92;
            stan::model::assign(g_p, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        (((psi * get_base1(g, C, "g", 1)) + (psi2 * get_base1(g, (C - 1), "g", 1))) + (get_base1(sigma, 2, "sigma", 1) * normal_rng(0, 1, base_rng__))), 
                        "assigning variable g_p");
            current_statement_begin__ = 93;
            stan::model::assign(g_p, 
                        stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list()), 
                        (((psi * get_base1(g_p, 1, "g_p", 1)) + (psi2 * get_base1(g, C, "g", 1))) + (get_base1(sigma, 2, "sigma", 1) * normal_rng(0, 1, base_rng__))), 
                        "assigning variable g_p");
            current_statement_begin__ = 94;
            for (int t = 3; t <= Tfor; ++t) {
                current_statement_begin__ = 94;
                stan::model::assign(g_p, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            (((psi * get_base1(g_p, (t - 1), "g_p", 1)) + (psi2 * get_base1(g_p, (t - 2), "g_p", 1))) + (get_base1(sigma, 2, "sigma", 1) * normal_rng(0, 1, base_rng__))), 
                            "assigning variable g_p");
            }
            current_statement_begin__ = 96;
            stan::math::assign(gf, append_row(g, g_p));
            current_statement_begin__ = 97;
            if (as_bool(logical_eq(family, 0))) {
                current_statement_begin__ = 98;
                for (int t = 1; t <= Tfor; ++t) {
                    current_statement_begin__ = 98;
                    for (int x = 1; x <= J; ++x) {
                        current_statement_begin__ = 99;
                        stan::model::assign(mufor, 
                                    stan::model::cons_list(stan::model::index_uni(pos), stan::model::nil_index_list()), 
                                    ((get_base1(a, x, "a", 1) + get_base1(k_p, t, "k_p", 1)) + get_base1(gf, (((T + t) - x) + J), "gf", 1)), 
                                    "assigning variable mufor");
                        current_statement_begin__ = 100;
                        stan::math::assign(pos, (pos + 1));
                    }
                }
                current_statement_begin__ = 102;
                stan::math::assign(mufor, stan::math::exp(mufor));
                current_statement_begin__ = 103;
                for (int t = 1; t <= T; ++t) {
                    current_statement_begin__ = 103;
                    for (int x = 1; x <= J; ++x) {
                        current_statement_begin__ = 104;
                        stan::model::assign(log_lik, 
                                    stan::model::cons_list(stan::model::index_uni(pos2), stan::model::nil_index_list()), 
                                    poisson_log_log(get_base1(d, pos2, "d", 1), (((get_base1(offset, pos2, "offset", 1) + get_base1(a, x, "a", 1)) + get_base1(k, t, "k", 1)) + get_base1(g, ((t - x) + J), "g", 1))), 
                                    "assigning variable log_lik");
                        current_statement_begin__ = 105;
                        stan::math::assign(pos2, (pos2 + 1));
                    }
                }
                current_statement_begin__ = 108;
                for (int t = 1; t <= Tval; ++t) {
                    current_statement_begin__ = 108;
                    for (int x = 1; x <= J; ++x) {
                        current_statement_begin__ = 109;
                        stan::model::assign(log_lik2, 
                                    stan::model::cons_list(stan::model::index_uni(pos3), stan::model::nil_index_list()), 
                                    poisson_log_log(get_base1(dval, pos3, "dval", 1), (((get_base1(offset2, pos3, "offset2", 1) + get_base1(a, x, "a", 1)) + get_base1(k_p, t, "k_p", 1)) + get_base1(gf, (((T + t) - x) + J), "gf", 1))), 
                                    "assigning variable log_lik2");
                        current_statement_begin__ = 110;
                        stan::math::assign(pos3, (pos3 + 1));
                    }
                }
            } else if (as_bool(logical_gt(family, 0))) {
                current_statement_begin__ = 114;
                for (int t = 1; t <= Tfor; ++t) {
                    current_statement_begin__ = 114;
                    for (int x = 1; x <= J; ++x) {
                        current_statement_begin__ = 115;
                        if (as_bool(logical_gt(stan::math::fabs(((get_base1(a, x, "a", 1) + get_base1(k_p, t, "k_p", 1)) + get_base1(gf, (((T + t) - x) + J), "gf", 1))), 15))) {
                            current_statement_begin__ = 116;
                            stan::model::assign(mufor, 
                                        stan::model::cons_list(stan::model::index_uni(pos), stan::model::nil_index_list()), 
                                        0, 
                                        "assigning variable mufor");
                            current_statement_begin__ = 117;
                            stan::math::assign(pos, (pos + 1));
                        } else {
                            current_statement_begin__ = 119;
                            stan::model::assign(mufor, 
                                        stan::model::cons_list(stan::model::index_uni(pos), stan::model::nil_index_list()), 
                                        gamma_rng(phi, (phi / stan::math::exp(((get_base1(a, x, "a", 1) + get_base1(k_p, t, "k_p", 1)) + get_base1(gf, (((T + t) - x) + J), "gf", 1)))), base_rng__), 
                                        "assigning variable mufor");
                            current_statement_begin__ = 120;
                            stan::math::assign(pos, (pos + 1));
                        }
                    }
                }
                current_statement_begin__ = 123;
                for (int t = 1; t <= T; ++t) {
                    current_statement_begin__ = 123;
                    for (int x = 1; x <= J; ++x) {
                        current_statement_begin__ = 124;
                        stan::model::assign(log_lik, 
                                    stan::model::cons_list(stan::model::index_uni(pos2), stan::model::nil_index_list()), 
                                    neg_binomial_2_log_log(get_base1(d, pos2, "d", 1), (((get_base1(offset, pos2, "offset", 1) + get_base1(a, x, "a", 1)) + get_base1(k, t, "k", 1)) + get_base1(g, ((t - x) + J), "g", 1)), phi), 
                                    "assigning variable log_lik");
                        current_statement_begin__ = 125;
                        stan::math::assign(pos2, (pos2 + 1));
                    }
                }
                current_statement_begin__ = 128;
                for (int t = 1; t <= Tval; ++t) {
                    current_statement_begin__ = 128;
                    for (int x = 1; x <= J; ++x) {
                        current_statement_begin__ = 129;
                        stan::model::assign(log_lik2, 
                                    stan::model::cons_list(stan::model::index_uni(pos3), stan::model::nil_index_list()), 
                                    neg_binomial_2_log_log(get_base1(dval, pos3, "dval", 1), (((get_base1(offset2, pos3, "offset2", 1) + get_base1(a, x, "a", 1)) + get_base1(k_p, t, "k_p", 1)) + get_base1(gf, (((T + t) - x) + J), "gf", 1)), phi), 
                                    "assigning variable log_lik2");
                        current_statement_begin__ = 130;
                        stan::math::assign(pos3, (pos3 + 1));
                    }
                }
            }
            // validate, write generated quantities
            current_statement_begin__ = 79;
            size_t k_p_j_1_max__ = Tfor;
            for (size_t j_1__ = 0; j_1__ < k_p_j_1_max__; ++j_1__) {
                vars__.push_back(k_p(j_1__));
            }
            current_statement_begin__ = 80;
            size_t g_p_j_1_max__ = Tfor;
            for (size_t j_1__ = 0; j_1__ < g_p_j_1_max__; ++j_1__) {
                vars__.push_back(g_p(j_1__));
            }
            current_statement_begin__ = 81;
            size_t gf_j_1_max__ = (C + Tfor);
            for (size_t j_1__ = 0; j_1__ < gf_j_1_max__; ++j_1__) {
                vars__.push_back(gf(j_1__));
            }
            current_statement_begin__ = 82;
            size_t mufor_j_1_max__ = L;
            for (size_t j_1__ = 0; j_1__ < mufor_j_1_max__; ++j_1__) {
                vars__.push_back(mufor(j_1__));
            }
            current_statement_begin__ = 83;
            size_t log_lik_j_1_max__ = (J * T);
            for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
                vars__.push_back(log_lik(j_1__));
            }
            current_statement_begin__ = 84;
            size_t log_lik2_j_1_max__ = (J * Tval);
            for (size_t j_1__ = 0; j_1__ < log_lik2_j_1_max__; ++j_1__) {
                vars__.push_back(log_lik2(j_1__));
            }
            current_statement_begin__ = 85;
            vars__.push_back(pos);
            current_statement_begin__ = 86;
            vars__.push_back(pos2);
            current_statement_begin__ = 87;
            vars__.push_back(pos3);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_APCmodel";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t aux_k_0_max__ = logical_gt(family, 0);
        for (size_t k_0__ = 0; k_0__ < aux_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "aux" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t a_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < a_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "a" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "c";
        param_names__.push_back(param_name_stream__.str());
        size_t ks_j_1_max__ = (T - 1);
        for (size_t j_1__ = 0; j_1__ < ks_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ks" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "psi";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "psi2";
        param_names__.push_back(param_name_stream__.str());
        size_t gs_j_1_max__ = (C - 2);
        for (size_t j_1__ = 0; j_1__ < gs_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gs" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sigma_k_0_max__ = 2;
        for (size_t k_0__ = 0; k_0__ < sigma_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t k_j_1_max__ = T;
            for (size_t j_1__ = 0; j_1__ < k_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "k" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t g_j_1_max__ = C;
            for (size_t j_1__ = 0; j_1__ < g_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "g" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            param_name_stream__.str(std::string());
            param_name_stream__ << "phi";
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__) return;
        size_t k_p_j_1_max__ = Tfor;
        for (size_t j_1__ = 0; j_1__ < k_p_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "k_p" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t g_p_j_1_max__ = Tfor;
        for (size_t j_1__ = 0; j_1__ < g_p_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "g_p" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t gf_j_1_max__ = (C + Tfor);
        for (size_t j_1__ = 0; j_1__ < gf_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gf" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t mufor_j_1_max__ = L;
        for (size_t j_1__ = 0; j_1__ < mufor_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mufor" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t log_lik_j_1_max__ = (J * T);
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t log_lik2_j_1_max__ = (J * Tval);
        for (size_t j_1__ = 0; j_1__ < log_lik2_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik2" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "pos";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "pos2";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "pos3";
        param_names__.push_back(param_name_stream__.str());
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t aux_k_0_max__ = logical_gt(family, 0);
        for (size_t k_0__ = 0; k_0__ < aux_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "aux" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t a_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < a_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "a" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "c";
        param_names__.push_back(param_name_stream__.str());
        size_t ks_j_1_max__ = (T - 1);
        for (size_t j_1__ = 0; j_1__ < ks_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ks" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "psi";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "psi2";
        param_names__.push_back(param_name_stream__.str());
        size_t gs_j_1_max__ = (C - 2);
        for (size_t j_1__ = 0; j_1__ < gs_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gs" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sigma_k_0_max__ = 2;
        for (size_t k_0__ = 0; k_0__ < sigma_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t k_j_1_max__ = T;
            for (size_t j_1__ = 0; j_1__ < k_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "k" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t g_j_1_max__ = C;
            for (size_t j_1__ = 0; j_1__ < g_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "g" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            param_name_stream__.str(std::string());
            param_name_stream__ << "phi";
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__) return;
        size_t k_p_j_1_max__ = Tfor;
        for (size_t j_1__ = 0; j_1__ < k_p_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "k_p" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t g_p_j_1_max__ = Tfor;
        for (size_t j_1__ = 0; j_1__ < g_p_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "g_p" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t gf_j_1_max__ = (C + Tfor);
        for (size_t j_1__ = 0; j_1__ < gf_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gf" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t mufor_j_1_max__ = L;
        for (size_t j_1__ = 0; j_1__ < mufor_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mufor" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t log_lik_j_1_max__ = (J * T);
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t log_lik2_j_1_max__ = (J * Tval);
        for (size_t j_1__ = 0; j_1__ < log_lik2_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik2" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "pos";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "pos2";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "pos3";
        param_names__.push_back(param_name_stream__.str());
    }
}; // model
}  // namespace
typedef model_APCmodel_namespace::model_APCmodel stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
