% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulatebootStMoMo.R
\name{simulate.bootStMoMo}
\alias{simulate.bootStMoMo}
\title{Simulate future sample paths from a Bootstrapped Stochastic 
Mortality Model}
\usage{
\method{simulate}{bootStMoMo}(object, nsim = 1, seed = NULL, h = 50,
  oxt = NULL, gc.order = c(1, 1, 0), gc.include.constant = TRUE,
  jumpchoice = c("fit", "actual"), kt.lookback = NULL, gc.lookback = NULL,
  ...)
}
\arguments{
\item{object}{an object of class \code{"bootStMoMo"} with the bootstrapped 
parameters of a stochastic mortality model.}

\item{nsim}{number of sample paths to simulate from each bootstrapped 
sample. Thus if there are \code{nBoot} bootstrapped samples the total 
number of paths will be \code{nsim * nBoot}.}

\item{seed}{either \code{NULL} or an integer that will be used in a 
call to \code{\link{set.seed}} before simulating the time series. 
The default, \code{NULL} will not change the random generator state.}

\item{h}{number of years ahead to forecast.}

\item{oxt}{optional array/matrix/vector or scalar of known offset to be 
added in the simulations. This can be used to specify any a priori known 
component to be added to the simulated predictor.}

\item{gc.order}{a specification of the ARIMA model: the three components 
\eqn{(p, d, q)} are the AR order, the degree of differencing, and the MA 
order. The default is an ARIMA\eqn{(1, 1, 0)}.}

\item{gc.include.constant}{a logical value indicating if the ARIMA model
should include a constant value. The default is \code{TRUE}.}

\item{jumpchoice}{option to select the jump-off rates, i.e. the rates 
from the final year of observation, to use in projections of mortality 
rates. \code{"fit"}(default) uses the fitted rates and \code{"actual"} 
uses the actual rates from the final year.}

\item{kt.lookback}{optional argument to specify the look-back window to use
in the estimation of the MRWD for period indexes. By default all the 
estimated values are used in estimating the MRWD. If 
\code{kt.lookback} is provided then the last \code{kt.lookback} 
years of \eqn{\kappa_t^{(i)}, i = 1,..N,} are used.}

\item{gc.lookback}{optional argument to specify the look-back window to use
in the estimation of the ARIMA model for the cohort effect. By 
default all the estimated values are used in estimating the ARIMA 
model. If \code{gc.lookback} is provided then the last 
\code{gc.lookback} years of \eqn{\gamma_{t-x}} are used.}

\item{...}{other arguments.}
}
\value{
A list of class \code{"simStMoMo"} with components

\item{rates}{ a three dimensional array with the future simulated rates.}

\item{ages}{ vector of ages corresponding to the first dimension of 
\code{rates}.}

\item{years}{ vector of years for which a simulations has been produced. 
This corresponds to the second dimension of \code{rates}.}  
 
\item{kt.s}{ information on the simulated paths of the period indices of 
the model. This is a list with the simulated paths of \eqn{\kappa_t}
 (\code{sim}) and the \code{years} for which simulations were produced. 
 If the mortality model does not have any age-period terms (i.e. \eqn{N=0})
 this is set to \code{NULL}.}
  
\item{gc.s}{ information on the simulated paths of the cohort index of the
 model. This is a list with the simulated paths of \eqn{\gamma_c} 
 (\code{sim}) and the \code{cohorts} for which simulations were produced. 
 If the mortality model does not have a cohort effect this is set to 
 \code{NULL}.} 
 
\item{oxt.s}{ a three dimensional array with the offset used in the 
simulations.}

\item{fitted}{ a three dimensional array with the in-sample rates of the 
model for the years for which the mortality model was fitted 
(and bootstrapped).}
 
 \item{jumpchoice}{Jump-off method used in the simulation.}
 
 \item{model}{the bootstrapped model from which the simulations were 
 produced.}
}
\description{
Simulate future sample paths from a Bootstrapped Stochastic Mortality Model.
The period indexes \eqn{\kappa_t^{(i)}, i = 1,..N,} are modelled
using a Multivariate Random Walk with Drift. The cohort index 
\eqn{\gamma_{t-x}} is modelled using an ARIMA\eqn{(p, d, q)}. By default
an ARIMA\eqn{(1, 1, 0)} with a constant is used.
}
\details{
For further details see \code{\link{simulate.fitStMoMo}}.
}
\examples{
#Long computing times
\dontrun{
#Lee-Carter: Compare projection with and without parameter uncertainty
library(fanplot)
LCfit <- fit(lc(), Dxt = EWMaleData$Dxt, Ext = EWMaleData$Ext, 
             ages = EWMaleData$ages, years = EWMaleData$years)
LCResBoot <- bootstrap(LCfit, nBoot = 500)
LCResBootsim <- simulate(LCResBoot)
LCsim <- simulate(LCfit, nsim = 500)#' 
plot(LCfit$years, log(LCfit$Dxt / LCfit$Ext)["10", ], 
     xlim = range(LCfit$years, LCsim$years),
     ylim = range(log(LCfit$Dxt / LCfit$Ext)["10", ], 
                  log(LCsim$rates["10", , ])),
     type = "l", xlab = "year", ylab = "log rate", 
     main = "Mortality rate projection at age 10 with and without parameter uncertainty") 
fan(t(log(LCResBootsim$rates["10", , ])),start = LCResBootsim$years[1], 
    probs = c(2.5, 10, 25, 50, 75, 90, 97.5), n.fan = 4, 
    fan.col = colorRampPalette(c(rgb(0, 0, 1), rgb(1, 1, 1))), ln = NULL)
fan(t(log(LCsim$rates["10", 1:(length(LCsim$years) - 3), ])),
    start = LCsim$years[1], probs = c(2.5, 10, 25, 50, 75, 90, 97.5),
    n.fan = 4, fan.col = colorRampPalette(c(rgb(1, 0, 0), rgb(1, 1, 1))), 
    ln = NULL)
}

}
\seealso{
\code{\link{bootstrap.fitStMoMo}}, \code{\link{simulate.fitStMoMo}}
}

