% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_kruskal.test.R
\name{p_kruskal.test}
\alias{p_kruskal.test}
\alias{gen_kruskal.test}
\title{p-value from Kruskal-Wallis Rank Sum Test simulation}
\usage{
p_kruskal.test(
  n,
  k,
  means,
  n.ratios = rep(1, k),
  gen_fun = gen_kruskal.test,
  ...
)

gen_kruskal.test(n, k, n.ratios, means, ...)
}
\arguments{
\item{n}{sample size per group}

\item{k}{number of groups}

\item{means}{vector of means to control location parameters}

\item{n.ratios}{allocation ratios reflecting the sample size ratios.
Default of 1 sets the groups to be the same size (n * n.ratio)}

\item{gen_fun}{function used to generate the required data.
Object returned must be a \code{list} of length \code{k}, where each element
contains the sample data in each group. Default uses \code{\link{gen_kruskal.test}}.
User defined version of this function must include the argument \code{...}}

\item{...}{additional arguments to pass to \code{gen_fun}}
}
\value{
a single p-value
}
\description{
Simulates data given two or more parent distributions and
returns a p-value using \code{\link{kruskal.test}}. Default generates data
from Gaussian distributions, however this can be modified.
}
\examples{

# three group test where data generate from Gaussian distributions
p_kruskal.test(n=30, k=3, means=c(0, .5, .6))

# generate data from chi-squared distributions with different variances
gen_chisq <- function(n, k, n.ratios, means, dfs, ...){
  dat <- vector('list', k)
  ns <- n * n.ratios
  for(g in 1:k)
 	dat[[g]] <- rchisq(ns[g], df=dfs[g]) - dfs[g] + means[g]
  dat
}

p_kruskal.test(n=30, k=3, means=c(0, 1, 2),
   gen_fun=gen_chisq, dfs=c(10, 15, 20))

\donttest{
  # empirical power estimate
  p_kruskal.test(n=30, k=3, means=c(0, .5, .6)) |> Spower()
  p_kruskal.test(n=30, k=3, means=c(0, 1, 2), gen_fun=gen_chisq,
         dfs = c(10, 15, 20)) |> Spower()

}

}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
