% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gatherCsv.R
\name{gatherCsv}
\alias{gatherCsv}
\title{Combine csv Files Containing Spectral Data into a Data Frame}
\usage{
gatherCsv()
}
\value{
A data frame containing the wavelengths in the first column and the
absorbances in the other columns, one per file, with the file name
generating the column name.  The data frame is written out in a file called
"All Spec Files.csv".
}
\description{
This function processes csv files containing two columns, wavelength and
absorbance (or intensity etc), into a data frame, which is then written out as a csv file.  The
files should have no header row.
}
\details{
It is assumed that the csv files have already been cleaned up so that they
contain only wavelength and absorbance data.  The wavelength data column
must be the same in all the files (as they would be if they came from the
same instrument with the same settings).
}
\seealso{
\code{\link{gatherSpecFiles}} which is the function the user should
call.
}
\author{
Bryan A. Hanson, DePauw University
}
\keyword{utilities}
