% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalMetrics.R
\name{blandAltmanLehPlot}
\alias{blandAltmanLehPlot}
\title{Generate Bland-Altman agreement plots between predicted and expected cell
type proportions of test data}
\usage{
blandAltmanLehPlot(
  object,
  colors,
  color.by = "CellType",
  facet.by = NULL,
  log.2 = FALSE,
  filter.sc = TRUE,
  density = TRUE,
  color.density = "darkblue",
  size.point = 0.05,
  alpha.point = 1,
  ncol = NULL,
  nrow = NULL,
  title = NULL,
  theme = NULL,
  ...
)
}
\arguments{
\item{object}{\code{\linkS4class{SpatialDDLS}} object with
\code{trained.model} slot containing metrics in the
\code{test.deconv.metrics} slot of a \code{\linkS4class{DeconvDLModel}}
object.}

\item{colors}{Vector of colors to be used.}

\item{color.by}{Variable used to color data. Options are \code{nCellTypes}
and \code{CellType}.}

\item{facet.by}{Variable used to show the data in different panels. If
\code{NULL}, the plot is not split into different panels. Options are
\code{nCellTypes} (by number of different cell types) and \code{CellType}
(by cell type).}

\item{log.2}{Whether to show the Bland-Altman agreement plot in log2 space
(\code{FALSE} by default).}

\item{filter.sc}{Boolean indicating whether single-cell profiles are filtered
out and only correlations of results associated with mixed spot profiles
are shown (\code{TRUE} by default).}

\item{density}{Boolean indicating whether density lines should be shown
(\code{TRUE} by default).}

\item{color.density}{Color of density lines if the \code{density} argument is
\code{TRUE}.}

\item{size.point}{Size of the points (0.1 by default).}

\item{alpha.point}{Alpha of the points (0.1 by default).}

\item{ncol}{Number of columns if \code{facet.by} is used.}

\item{nrow}{Number of rows if \code{facet.by} is used.}

\item{title}{Title of the plot.}

\item{theme}{\pkg{ggplot2} theme.}

\item{...}{Additional argument for the \code{facet_wrap} function of
\pkg{ggplot2} if \code{facet.by} is not \code{NULL}.}
}
\value{
A ggplot object.
}
\description{
Generate Bland-Altman agreement plots between predicted and expected cell
type proportions from test data. The Bland-Altman agreement plots can be
shown all mixed or split by either cell type (\code{CellType}) or the number
of cell types present in spots (\code{nCellTypes}). See the \code{facet.by}
argument and examples for more information.
}
\examples{
\donttest{
set.seed(123)
sce <- SingleCellExperiment::SingleCellExperiment(
  assays = list(
    counts = matrix(
      rpois(30, lambda = 5), nrow = 15, ncol = 20,
      dimnames = list(paste0("Gene", seq(15)), paste0("RHC", seq(20)))
    )
  ),
  colData = data.frame(
    Cell_ID = paste0("RHC", seq(20)),
    Cell_Type = sample(x = paste0("CellType", seq(6)), size = 20,
                       replace = TRUE)
  ),
  rowData = data.frame(
    Gene_ID = paste0("Gene", seq(15))
  )
)
SDDLS <- createSpatialDDLSobject(
  sc.data = sce,
  sc.cell.ID.column = "Cell_ID",
  sc.gene.ID.column = "Gene_ID",
  sc.filt.genes.cluster = FALSE
)
SDDLS <- genMixedCellProp(
  object = SDDLS,
  cell.ID.column = "Cell_ID",
  cell.type.column = "Cell_Type",
  num.sim.spots = 50,
  train.freq.cells = 2/3,
  train.freq.spots = 2/3,
  verbose = TRUE
)
SDDLS <- simMixedProfiles(SDDLS)
# training of DDLS model
SDDLS <- trainDeconvModel(
  object = SDDLS,
  batch.size = 15,
  num.epochs = 5
)
# evaluation using test data
SDDLS <- calculateEvalMetrics(object = SDDLS)
# Bland-Altman plot by cell type
blandAltmanLehPlot(
  object = SDDLS,
  facet.by = "CellType",
  color.by = "CellType"
)
# Bland-Altman plot of all samples mixed
blandAltmanLehPlot(
  object = SDDLS,
  facet.by = NULL,
  color.by = "CellType",
  alpha.point = 0.3,
  log2 = TRUE
)
}

}
\seealso{
\code{\link{calculateEvalMetrics}} \code{\link{corrExpPredPlot}}
\code{\link{distErrorPlot}} \code{\link{barErrorPlot}}
}
