% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/SpatPCA.R
\name{covfn}
\alias{covfn}
\title{Covariance matrix estimation}
\usage{
covfn(basis, M = 5, gamma = NULL)
}
\arguments{

\item{basis}{"spatpca" object.}

\item{M}{Optional number of folds; default is 5.}

\item{gamma}{Optional user-supplied numeric vector of a nonnegative tuning parameter sequence. If NULL, 10 values in a range are used.}
}
\value{
\item{cov}{Estimated covariance matrix at the locations with respect to the selected tuning parameter.}

\item{sgamma}{Selected gamma.}

\item{cv}{cv socres corresponding to gamma.}

\item{gamma}{Sequence of gamma-values used in the process.}
}
\description{
Produce the estimated covariance matrix based on M-fold cross-validation to select the tuning parameter.
}
\examples{
\dontrun{
## 1D case
x_1D <- as.matrix(seq(-5, 5, length = 50))
Phi_1D <- exp(-x_1D^2)/norm(exp(-x_1D^2), "F")
Y_1D <- rnorm(n = 100, sd = 2)\%*\%t(Phi_1D) + matrix(rnorm(n = 100*50), 100, 50)
cv_1D <- spatpca(x = x_1D, Y = Y_1D)
cov_est <- covfn(basis = cv_1D)}
}
\author{
Wen-Ting Wang and Hsin-Cheng Huang
}
\references{
Tzeng, S. and Huang, H.-C. (2015). Non-stationary multivariate spatial covariance estimation via low-rank regularization. \emph{Statistical Sinica} \bold{26} 151-172.

Wang, W.-T. and Huang, H.-C. (2015). Regularized principal component analysis for spatial data. arXiv:1501.03221.
}
\seealso{
\code{\link{spatpca}}}


