% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/SpatPCA.R
\name{cv.spatpca}
\alias{cv.spatpca}
\title{M-fold cross-validation for eigenfunction estimation}
\usage{
cv.spatpca(Y, sx, sy = NULL, M = 5, K, tau1 = NULL, tau2 = NULL,
  center = FALSE, plot.eigen = TRUE, plot.cv = TRUE, parallel = FALSE,
  ...)
}
\arguments{
\item{Y}{Data matrix (\eqn{n \times p}) stores the values at \eqn{p} locations with sample size \eqn{n}.}

\item{sx}{Numeric vector of \eqn{x}-coordinates of grids.}

\item{sy}{Numeric vector of \eqn{y}-coordinates of grids. If NULL, it is a one-dimensional case.}

\item{M}{Optional number of folds; default is 5. Smallest value allowable is M=2.}

\item{K}{User-supplied number of eigenfunctions.}

\item{tau1}{Optional user-supplied numeric vector of a nonnegative smoothness parameter sequence. If NULL, 10 values in a range are used.}

\item{tau2}{Optional user-supplied numeric vector of a nonnegative sparseness parameter sequence. If NULL, 10 values in a range are used.}

\item{center}{If TRUE, center the columns of Y. Default is FALSE.}

\item{plot.eigen}{If TRUE, plot the estimated eigenfunctions. Default is TRUE.}

\item{plot.cv}{If TRUE, plot the image of cv values. Default is TRUE.}

\item{parallel}{If TRUE, see the example below. Default is FALSE.}

\item{...}{Additional arguments passed to \code{\link{spatpca}}.}
}
\value{
\item{eigenfn.cv}{Estimated eigenfunctions at the locations with respect to selected tuning parameters.}

\item{tau1.cv}{Selected tau1.}

\item{tau2.cv}{Selected tau2.}

\item{cv}{cv socres.}

\item{tau1}{Sequence of tau1-values used in the process.}

\item{tau2}{Sequence of tau2-values used in the process.}
}
\description{
Execute M-fold cross-validation to select the tuning parameters, tau1 and tau2, and produce the corresponding estimated eigenfunctions.
}
\examples{
\dontrun{
## 1D case
s.1D <- as.matrix(seq(-5, 5, length = 50))
Phi.true.1D <- exp(-s.1D^2)/norm(exp(-s.1D^2), "F")
Y.1D <- rnorm(n = 100, sd = 3)\%*\%t(Phi.true.1D) + matrix(rnorm(n = 100*50), 100, 50)
cv.1D <- cv.spatpca(Y = Y.1D, sx = s.1D, K = 3)

## 2D case
s.2D <- matrix(c(seq(-5, 5, length = 10), seq(-5, 5, length = 10)), nrow = 10, ncol = 2)
Phi.true.2D <- exp(-s.2D[,1]^2)\%*\%t(exp(-s.2D[,2]^2))
Phi.true.2D <- matrix(Phi.true.2D/norm(Phi.true.2D, "F"), ncol = 100, nrow = 1) 
Y.2D <- rnorm(n = 100, sd = 3)\%*\%(Phi.true.2D) + matrix(rnorm(100*100), 100, 100)
cv.2D <- cv.spatpca(Y = Y.2D, sx = s.2D[,1], sy = s.2D[,2], K = 3)

## 2D case - parallel
library(doParallel)
cl <- makeCluster(4) 
registerDoParallel(cl)
cv.2D <- cv.spatpca(Y = Y.2D, sx = s.2D[,1], sy = s.2D[,2], K = 3, parallel = TRUE)
stopCluster(cl)}}
\author{
Wen-Ting Wang and Hsin-Cheng Huang
}
\references{
Wang, W.-T. and Huang, H.-C. (2015). Regularized principal component analysis for spatial data. arXiv:1501.03221.
}
\seealso{
\code{\link{spatpca}}
}

