% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shannon.R
\name{shannonZ_sq}
\alias{shannonZ_sq}
\title{Shannon's entropy of \eqn{Z} with a squared information function.}
\usage{
shannonZ_sq(shannZ)
}
\arguments{
\item{shannZ}{Output of \code{\link[=shannonZ]{shannonZ()}}}
}
\value{
Estimated probabilities for all \eqn{Z} categories (data pairs), and Shannon's entropy of \eqn{Z} with a squared information function.
}
\description{
This function computes Shannon's entropy of \eqn{Z} with the square of the information function.
}
\details{
This computes a version of Shannon's entropy of \eqn{Z} (see \code{\link[=shannonZ]{shannonZ()}}) where
the information function \eqn{\log(1/p(z_r))} is squared:
\deqn{H(Z)_2=\sum p(z_r)\log(1/p(z_r))^2}
It is useful for estimating the
variance of the maximum likelihood estimator of Shannon's entropy given by
\code{\link[=shannonZ]{shannonZ()}}.
}
\examples{
#NON SPATIAL DATA
shZ=shannonZ(sample(1:5, 50, replace=TRUE))
shannonZ_sq(shZ)

#POINT DATA
data.pp=runifpoint(100, win=square(10))
marks(data.pp)=sample(c("a","b","c"), 100, replace=TRUE)
shZ=shannonZ(marks(data.pp))
shannonZ_sq(shZ)

#LATTICE DATA
data.lat=matrix(sample(c("a","b","c"), 100, replace=TRUE), nrow=10)
shZ=shannonZ(data.lat)
shannonZ_sq(shZ)

}
