% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/DataFrame.R
\docType{methods}
\name{unionByName}
\alias{unionByName}
\alias{unionByName}
\alias{unionByName,SparkDataFrame,SparkDataFrame-method}
\title{Return a new SparkDataFrame containing the union of rows, matched by column names}
\usage{
unionByName(x, y)

\S4method{unionByName}{SparkDataFrame,SparkDataFrame}(x, y)
}
\arguments{
\item{x}{A SparkDataFrame}

\item{y}{A SparkDataFrame}
}
\value{
A SparkDataFrame containing the result of the union.
}
\description{
Return a new SparkDataFrame containing the union of rows in this SparkDataFrame
and another SparkDataFrame. This is different from \code{union} function, and both
\code{UNION ALL} and \code{UNION DISTINCT} in SQL as column positions are not taken
into account. Input SparkDataFrames can have different data types in the schema.
}
\details{
Note: This does not remove duplicate rows across the two SparkDataFrames.
This function resolves columns by name (not by position).
}
\note{
unionByName since 2.3.0
}
\examples{
\dontrun{
sparkR.session()
df1 <- select(createDataFrame(mtcars), "carb", "am", "gear")
df2 <- select(createDataFrame(mtcars), "am", "gear", "carb")
head(unionByName(df1, df2))
}
}
\seealso{
\link{rbind} \link{union}

Other SparkDataFrame functions: \code{\link{SparkDataFrame-class}},
  \code{\link{agg}}, \code{\link{alias}},
  \code{\link{arrange}}, \code{\link{as.data.frame}},
  \code{\link{attach,SparkDataFrame-method}},
  \code{\link{broadcast}}, \code{\link{cache}},
  \code{\link{checkpoint}}, \code{\link{coalesce}},
  \code{\link{collect}}, \code{\link{colnames}},
  \code{\link{coltypes}},
  \code{\link{createOrReplaceTempView}},
  \code{\link{crossJoin}}, \code{\link{cube}},
  \code{\link{dapplyCollect}}, \code{\link{dapply}},
  \code{\link{describe}}, \code{\link{dim}},
  \code{\link{distinct}}, \code{\link{dropDuplicates}},
  \code{\link{dropna}}, \code{\link{drop}},
  \code{\link{dtypes}}, \code{\link{except}},
  \code{\link{explain}}, \code{\link{filter}},
  \code{\link{first}}, \code{\link{gapplyCollect}},
  \code{\link{gapply}}, \code{\link{getNumPartitions}},
  \code{\link{group_by}}, \code{\link{head}},
  \code{\link{hint}}, \code{\link{histogram}},
  \code{\link{insertInto}}, \code{\link{intersect}},
  \code{\link{isLocal}}, \code{\link{isStreaming}},
  \code{\link{join}}, \code{\link{limit}},
  \code{\link{localCheckpoint}}, \code{\link{merge}},
  \code{\link{mutate}}, \code{\link{ncol}},
  \code{\link{nrow}}, \code{\link{persist}},
  \code{\link{printSchema}}, \code{\link{randomSplit}},
  \code{\link{rbind}}, \code{\link{registerTempTable}},
  \code{\link{rename}}, \code{\link{repartition}},
  \code{\link{rollup}}, \code{\link{sample}},
  \code{\link{saveAsTable}}, \code{\link{schema}},
  \code{\link{selectExpr}}, \code{\link{select}},
  \code{\link{showDF}}, \code{\link{show}},
  \code{\link{storageLevel}}, \code{\link{str}},
  \code{\link{subset}}, \code{\link{summary}},
  \code{\link{take}}, \code{\link{toJSON}},
  \code{\link{union}}, \code{\link{unpersist}},
  \code{\link{withColumn}}, \code{\link{withWatermark}},
  \code{\link{with}}, \code{\link{write.df}},
  \code{\link{write.jdbc}}, \code{\link{write.json}},
  \code{\link{write.orc}}, \code{\link{write.parquet}},
  \code{\link{write.stream}}, \code{\link{write.text}}
}
