% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/functions.R
\docType{methods}
\name{substring_index}
\alias{substring_index}
\alias{substring_index}
\alias{substring_index,Column,character,numeric-method}
\title{substring_index}
\usage{
substring_index(x, delim, count)

\S4method{substring_index}{Column,character,numeric}(x, delim, count)
}
\arguments{
\item{x}{a Column.}

\item{delim}{a delimiter string.}

\item{count}{number of occurrences of \code{delim} before the substring is returned.
A positive number means counting from the left, while negative means
counting from the right.}
}
\description{
Returns the substring from string str before count occurrences of the delimiter delim.
If count is positive, everything the left of the final delimiter (counting from left) is
returned. If count is negative, every to the right of the final delimiter (counting from the
right) is returned. substring_index performs a case-sensitive match when searching for delim.
}
\note{
substring_index since 1.5.0
}
\examples{
\dontrun{
substring_index(df$c, '.', 2)
substring_index(df$c, '.', -1)
}
}
\seealso{
Other string_funcs: \code{\link{ascii}},
  \code{\link{base64}}, \code{\link{concat_ws}},
  \code{\link{concat}}, \code{\link{decode}},
  \code{\link{encode}}, \code{\link{format_number}},
  \code{\link{format_string}}, \code{\link{initcap}},
  \code{\link{instr}}, \code{\link{length}},
  \code{\link{levenshtein}}, \code{\link{locate}},
  \code{\link{lower}}, \code{\link{lpad}},
  \code{\link{ltrim}}, \code{\link{regexp_extract}},
  \code{\link{regexp_replace}}, \code{\link{reverse}},
  \code{\link{rpad}}, \code{\link{rtrim}},
  \code{\link{soundex}}, \code{\link{translate}},
  \code{\link{trim}}, \code{\link{unbase64}},
  \code{\link{upper}}
}
