% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module-repository.R
\docType{methods}
\name{downloadModule}
\alias{downloadModule}
\alias{downloadModule,character,ANY,ANY,ANY,ANY,ANY-method}
\alias{downloadModule,character,character,character,character,logical,logical-method}
\alias{downloadModule,character,missing,missing,missing,missing,missing-method}
\title{Download a module from a SpaDES module GitHub repository}
\usage{
downloadModule(name, path, version, repo, data, quiet)


  \S4method{downloadModule}{character,character,character,character,logical,logical}(name,
  path, version, repo, data, quiet)


  \S4method{downloadModule}{character,missing,missing,missing,missing,missing}(name)

\S4method{downloadModule}{character,ANY,ANY,ANY,ANY,ANY}(name, path, version,
  repo, data, quiet)
}
\arguments{
\item{name}{Character string giving the module name.}

\item{path}{Character string giving the location in which to save the
downloaded module.}

\item{version}{The module version to download. (If not specified, or \code{NA},
the most recent version will be retrieved.)}

\item{repo}{GitHub repository name.
Default is \code{"PredictiveEcology/SpaDES-modules"}, which is
specified by the global option \code{spades.moduleRepo}.}

\item{data}{Logical. If TRUE, then the data that is identified in the module
metadata will be downloaded, if possible. Default if FALSE.}

\item{quiet}{Logical. This is passed to \code{download.file}. Default is FALSE.}
}
\value{
A list of length 2. The first elemet is a character vector containing
   a character vector of extracted files for the module. The second element is
   a tbl with details about the data that is relevant for the function, including
   whether it was downloaded or not, whether it was renamed (because there
   was a local copy that had the wrong file name).
}
\description{
Download a .zip file of the module and extract (unzip) it to a user-specified location.
}
\details{
Currently only works with a public GitHub repository, where modules are in
a \code{modules} directory in the root tree on the \code{master} branch.

NOTE: the default is to overwrite any existing files in the case of a conflict.
}
\author{
Alex Chubaty
}

