% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/load.R, R/save.R
\docType{methods}
\name{loadFiles}
\alias{.fileExtensions}
\alias{.saveFileExtensions}
\alias{loadFiles}
\alias{loadFiles,missing,ANY-method}
\alias{loadFiles,missing,missing-method}
\alias{loadFiles,simList,missing-method}
\title{Load simulation objects according to \code{filelist}}
\usage{
loadFiles(sim, filelist, ...)

\S4method{loadFiles}{simList,missing}(sim, filelist, ...)

\S4method{loadFiles}{missing,ANY}(sim, filelist, ...)

\S4method{loadFiles}{missing,missing}(sim, filelist, ...)

.fileExtensions()

.saveFileExtensions()
}
\arguments{
\item{sim}{\code{simList} object.}

\item{filelist}{\code{list} or \code{data.frame} to call \code{loadFiles} directly from the
                 \code{filelist} as described in Details}

\item{...}{Additional arguments.}
}
\description{
This function takes the filelist argument in the \code{simList} object and
loads all the files using the identified functions and arguments.

How to load various types of files in R.

How to load various types of files in R.
}
\details{
In the \code{filelist} object, either a \code{list} or a \code{data.frame},
there will be minimally a column called "files".
All other columns are optional.

Other optional columns are:

- \code{objectName}: a character string indicating the name of the object once the
file is loaded. Default is to use the file names, with file extension removed.

- \code{package}: a character string indicating the package that the function is found in.
There is no default.

- \code{functions}: a character string indicating the function to be used to load the file.
Default is to use the mapping between file extensions in the \code{.fileExtensions} function
and the actual file extensions.

- \code{intervals}: a numeric indicating the interval between repeated loading of the same
file. This should be NA or the column absent if the file is only loaded once. Default is
absent, so files are loaded only at \code{start} in the \code{simList}.

- \code{loadTime}: a numeric indicating when the file should be loaded. Defaults to
\code{simTime=0},but this can be any time. The loading will be scheduled to occur
at the "loadTime", whatever that is. If the same file is to loaded many times,
but not at a regular interval, then there should be separate line, with a unique
loadTime for each.

- \code{arguments}: is a list of lists of named arguments, one list for each loading function.
For example, if raster is a loading function, \code{arguments = list(native = TRUE)}.
If there is only one list, then it is assumed to apply to all load attempts
and will be repeated for each load function.
}
\examples{
\dontrun{
# Load random maps included with package
filelist <- data.frame(
    files=dir(file.path(find.package("SpaDES", quiet=FALSE), "maps"),
    full.names=TRUE, pattern="tif"), functions="rasterToMemory", package="SpaDES"
    )

times <- list(start=0, end=3)
parameters <- list(.globals=list(stackName="landscape"))
modules <- list("randomLandscapes", "caribouMovement")
paths <- list(moduleName=system.file("sampleModules", package="SpaDES"))
mySim <- simInit(times=times, params=parameters, modules=modules, paths=paths,
inputs=filelist)
ls(mySim)

sim1 <- loadFiles(filelist=filelist)
clearPlot()
Plot(sim1$DEM)
}

\dontrun{
# Second, more sophisticated. All maps loaded at time = 0, and the last one is reloaded
#  at time = 10 and 20 (via "intervals").
# Also, pass the single argument as a list to all functions...
#  specifically, when add "native = TRUE" as an argument to the raster function
files = dir(file.path(find.package("SpaDES", quiet = FALSE), "maps"),
        full.names=TRUE, pattern= "tif")
arguments = I(rep(list(native=TRUE), length(files)))
filelist = data.frame(
   files = files,
   functions="raster::raster",
   objectName = NA,
   arguments = arguments,
   loadTime = 0,
   intervals = c(rep(NA, length(files)-1), 10)
   )

sim2 <- loadFiles(filelist=filelist)
end(sim2) <- 20
sim2 <- spades(sim2)
}
}
\author{
Eliot McIntire

Alex Chubaty
}

