% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/studyArea.R
\name{randomStudyArea}
\alias{randomStudyArea}
\title{Create default study areas for use with \code{SpaDES} modules}
\usage{
randomStudyArea(center = NULL, size = 10000, seed = NULL)
}
\arguments{
\item{center}{\code{SpatialPoints} object specifying a set of coordinates and
a projection. Default is an area in southern Alberta, Canada.}

\item{size}{Numeric specifying the approximate size of the area in m^2.
Default \code{1e4}.}

\item{seed}{Numeric indicating the random seed to set internally
(useful for ensuring the same study area is produced each time).}
}
\value{
\code{SpatVector}
}
\description{
Create default study areas for use with \code{SpaDES} modules
}
\examples{
a <- randomStudyArea(seed = 123)
if (interactive()) {
  terra::plot(a)
}
}
