% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveLoadSimList.R
\name{loadSimList}
\alias{loadSimList}
\alias{unzipSimList}
\title{Load a saved \code{simList} and ancillary files}
\usage{
loadSimList(filename, paths = getPaths(), otherFiles = "")

unzipSimList(zipfile, load = TRUE, paths = getPaths(), ...)
}
\arguments{
\item{filename}{Character giving the name of a saved simulation file.
Currently, only file types \code{.qs} or \code{.rds} are supported.}

\item{paths}{A list of character vectors for all the \code{simList} paths. When
loading a \code{simList}, this will replace the paths of everything to
these new paths. Experimental still.}

\item{otherFiles}{A character vector of (absolute) file names locating each of the
existing file-backed \verb{Raster*} files that are the real paths for the possibly
incorrect paths in \code{Filenames(sim)} if the the \code{file} being read in is from
a different computer, path, or drive. This could be the output from \code{unzipSimList}
(which is calls \code{loadSimList} internally, passing the unzipped filenames)}

\item{zipfile}{Filename of a zipped simList}

\item{load}{Logical. If \code{TRUE}, the default, then the simList will
also be loaded into R.}

\item{...}{passed to \code{unzip}}
}
\value{
\itemize{
\item \code{\link[=loadSimList]{loadSimList()}}: A \code{simList} object.
\item \code{\link[=unzipSimList]{unzipSimList()}}: Either a character vector of file names unzipped (if \code{load = FALSE}),
or a \code{simList} object.
}
}
\description{
Loading a \code{simList} from file can be problematic as there are non-standard
objects that must be rebuilt. See description in \code{\link[=saveSimList]{saveSimList()}} for details.

\code{unzipSimList} is a convenience wrapper around \code{unzip} and \code{loadSimList} where
all the files are correctly identified and passed to
\code{loadSimList(..., otherFiles = xxx)}. See \link{zipSimList} for details.
}
\details{
If \code{cache} is used, it is likely that it should be trimmed before
zipping, to include only cache elements that are relevant.
}
\seealso{
\code{\link[=saveSimList]{saveSimList()}}, \code{\link[=zipSimList]{zipSimList()}}
}
