% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainFunctions.R
\name{sourceCytoscape}
\alias{sourceCytoscape}
\title{Visualize in Cytoscape a collection of graphs analyzed with the source set algorithm}
\usage{
sourceCytoscape(
  sourceObj,
  name.graphs = names(sourceObj),
  collection.name = "SourceCollection",
  map.name.variable = NULL,
  method = "bonferroni"
)
}
\arguments{
\item{sourceObj}{a \code{SourceSetObj} objects, i.e. the output of the \code{\link[SourceSet]{sourceSet}} function.}

\item{name.graphs}{the names of the graphs to be visualized. Default value is \code{names(sourceObj)}. NOTE: even if a subset of graphs are selected in \code{name.graphs}, the returned statistics are always calculated on the entire collection in the \code{sourceObj} argument.}

\item{collection.name}{name of the collection of graphs displayed in Cytoscape.}

\item{map.name.variable}{a list of customized labels to be associated with the names of the genes. Each list element must contain only one value (i.e. the new label), and the name of each element must be associated with the names of the genes given as input to the \code{\link[SourceSet]{sourceSet}} function (column names of \code{data} input argument). If a label is not mapped, the original name is used.}

\item{method}{correction method for p-values calculated on graphs. The adjustment methods allowed are: \code{fdr} (default), \code{holm}, \code{hochberg}, \code{hommel}, \code{bonferroni}, \code{BH}, \code{BY} or \code{none}. For more details refer to \code{\link[stats]{p.adjust}}.}
}
\value{
The function returns an interactive session in Cytoscape.?
}
\description{
The function, thanks to the connection with the Cytoscape software, allows the user to create a collection of graphs to be visualized in a unique session, while documenting interesting findings.
}
\details{
The visual node attributes size and fill color are defined in a dynamic manner through a visual mapping based on the indices provided by the \code{\link[SourceSet]{infoSource}} function (automatically uploaded in the bottom panel - right side).

A discrete mapper between \code{source} attribute and size is applied:
\itemize{
  \item{big size: the variable belongs to the primary set (\code{source=2});}
  \item{medium size: the variable belongs to the secondary set (\code{source=1});}
  \item{small size: otherwise (\code{source=0}).}
}
On the other hand, a color gradient mapper between fill node color and \code{relevance} is adopted: higher values are highlighted with darker blue color.

The default style can be changed manually either within Cytoscape (for further information see \href{http://manual.cytoscape.org/en/stable/Styles.html}{manual}) or within an R package \code{r2cytoscape} through network SUID returned by the \code{sourceCytoscape function} (for further details see \href{https://github.com/cytoscape/r2cytoscape}{manual}).

It is also possible to call the sourceCytoscape function multiple times, with all the graphs being visualized in a unique session within a collection specified by collection.name.
}
\note{
The function use the \code{r2cytoscape} package to connect to Cytoscape from R using CyREST. \code{r2cytoscape} can be downloaded from:
\itemize{
   \item{Bioconductor: \code{biocLite("r2cytoscape")};}
   \item{GitHub: \code{install_github("cytoscape/r2cytoscape")}.}
}

To enable the display function to work properly, three simple steps are required:
\itemize{
   \item{ Download \href{https://cytoscape.org/download.php}{Cytoscape} (version 3.3 or later);}
   \item{ Complete installation wizard;}
   \item{ Launch Cytoscape (before calling the functions).}
}
}
\examples{
## Load the SourceSetObj obtained from the source set analysis of ALL dataset

# see vignette for more details
print(load(file=system.file("extdata","ALLsourceresult.RData",package = "SourceSet")))
class(results.all)

## NB: Remember to launch cytoscape before running the following commands
# Create two collections of pathways to visualize the results
graph.signaling<-names(results.all)[grep("signaling",names(results.all))]
graph.other<-setdiff(names(results.all),graph.signaling)

## Signaling collection

if(interactive()){
cytoID.signaling<-sourceCytoscape(results.all,
    name.graphs = graph.signaling, collection.name ="SignalingPathway")
}

## Other collection
if(interactive()){
cytoID.other<-sourceCytoscape(results.all,
    name.graphs = graph.other, collection.name ="OtherPathway")
}


}
\seealso{
\code{\link[SourceSet]{sourceSet}}, \code{\link[SourceSet]{infoSource}}. \code{\link[SourceSet]{sourceUnionCytoscape}}, \code{r2cytoscape}
}
