% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classFunctions.R
\name{SoupChannel}
\alias{SoupChannel}
\title{Construct a SoupChannel object}
\usage{
SoupChannel(tod, toc, metaData = NULL, calcSoupProfile = TRUE, ...)
}
\arguments{
\item{tod}{Table of droplets.  A matrix with columns being each droplet and rows each gene.}

\item{toc}{Table of counts.  Just those columns of \code{tod} that contain cells.}

\item{metaData}{Meta data pertaining to the cells.  Optional.  Must be a data-frame with rownames equal to column names of \code{toc}.}

\item{calcSoupProfile}{By default, the soup profile is calculated using \code{\link{estimateSoup}} with default values.  If you want to do something other than the defaults, set this to \code{FALSE} and call \code{\link{estimateSoup}} manually.}

\item{...}{Any other named parameters to store.}
}
\value{
A SoupChannel object.
}
\description{
Creates a SoupChannel object that contains everything related to the soup estimation of a single channel.
}
\examples{
#Load droplet and count tables
tod = Seurat::Read10X(system.file('extdata','toyData','raw_gene_bc_matrices','GRCh38',
                                  package='SoupX'))
toc = Seurat::Read10X(system.file('extdata','toyData','filtered_gene_bc_matrices','GRCh38',
                                  package='SoupX'))
#Default calculates soup profile
sc = SoupChannel(tod,toc)
names(sc)
#This can be suppressed
sc = SoupChannel(tod,toc,calcSoupProfile=FALSE)
names(sc)
}
\seealso{
SoupChannelList estimateSoup setSoupProfile setClusters
}
