% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WangThreePoolNonAutonomous_sym.R
\name{WangThreePoolNonAutonomous_sym}
\alias{WangThreePoolNonAutonomous_sym}
\title{A non-autonomous version of the original Wang 3 pool model}
\usage{
WangThreePoolNonAutonomous_sym(
  alpha = 0.5,
  epsilon = 0.4,
  mu_b = 0.2,
  F_NPP = 3e+06,
  V_l = 0.5,
  V_s = 0.5,
  K_l = 1e+05,
  K_s = 100
)
}
\arguments{
\item{alpha}{fraction of carbon influx that directly enters the soil organic matter pool}

\item{epsilon}{microbial growth efficiency}

\item{mu_b}{turnover rate of microbial biomass per year, unit: "year^{-1}"}

\item{F_NPP}{carbon influx into soil, unit: "g C*m^{-2}*year^{-1}"}

\item{V_l}{maximum rate of litter carbon assimilation per unit microbial biomass per year}

\item{V_s}{maximum rate of soil carbon assimilation per unit microbial biomass per year}

\item{K_l}{half-saturation constant for litter carbon assimilation by microbial biomass}

\item{K_s}{half-saturation constant for soil carbon assimilation by microbial biomass}
}
\description{
An Example based on the original non-linear autonomous model as described in  
Wang et al. (2014)
with state_variables:
\enumerate{
 \item C_l
   desc: litter carbon
   unit: "g C m^{-2}"
 \item C_s
   desc: soil organic matter
   unit: "g C m^{-2}"
 \item C_b: 
   desc: microbial biomass
   unit: "g C m^{-2}"
}
Note that this is not a complete model run like most of the models in SoilR but a 
description of the fluxes that can be extended to a model run if initial values
and times are specified.
The default values are completely arbitrary.
So is one time dependency that has been added to demonstrate that this is possible everywhere and every 
part of the model can become non-autonomous. 
At the moment the variable t is mostly ignored like in the original Wang Model except for the first
influx to pool C_l.
}
\examples{
# This is a working example which demostrates some of the new functionality.
require('SoilR',quietly =TRUE)
smod <- WangThreePoolNonAutonomous_sym() 
# (look at the source code of WangThreePoolNonAutonomous_sym )
plotPoolGraph(smod)
state_variable_names(smod)
# define initial values for the state variables
iv=c(C_l=1000,C_b=5000,C_s=1000)
times<-seq(from=1,to=1000,by=10)
modrun=Model_by_PoolNames( smod=smod ,times=times ,initialValues=iv)
sol <- getSolution(modrun)
# Let's see what we have computed
colnames(sol)
# shortcut overview plot for all phase plane projections and time lines
# of the pool contents
 plot(data.frame(times=times,sol[,c('C_l','C_s','C_b')]))
# plot fluxes as functions of time

in_fluxes <- sol[,grep('influxes',colnames(sol))]
plot( times, sol[,'influxes.C_l'] ,type='l'
  ,ylim=c(min(in_fluxes),max(in_fluxes))
)
lines( times, sol[,'influxes.C_l'] ,type='l'
  ,ylim=c(min(in_fluxes),max(in_fluxes))
)
internal_fluxes <- sol[,grep('internal_fluxes',colnames(sol))]
plot(
  times, sol[,'internal_fluxes.C_l->C_b'] ,type='l'
  ,ylim=c(min(internal_fluxes),max(internal_fluxes))
)
}
