% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tillage_intensity.R
\name{tillage_intensity}
\alias{tillage_intensity}
\title{Estimate tillage intensity}
\usage{
tillage_intensity(var_MGMT_data, extended.output = FALSE)
}
\arguments{
\item{var_MGMT_data}{a \code{management_df} that contains the management information}

\item{extended.output}{an optional logical value. Default value is \code{FALSE}
\itemize{
\item If \code{FALSE}, \code{STIR} values are aggregated by year.
\item If \code{TRUE}, a tibble with all management operations is returned.
}}
}
\value{
by default, a tibble with STIR values by year is returned. If extended.output = TRUE, a tibble with daily resolution is returned.
}
\description{
Calculates the soil tillage intensity per year.
The function takes a \code{management_df} as input and returns a \code{STIR} value
per year in the \code{management_df.} Alternatively, it can return a
extensive tibble with each operation and their respective \code{STIR} values.
}
\examples{
#example that returns annual STIR values
tillage_intensity(EXAMPLE_data)

#example that returns a tibble with all operations that have a STIR value
tillage_intensity(EXAMPLE_data, extended.output = TRUE)

}
\seealso{
\itemize{
\item \code{\link[=STIR]{STIR()}} for the calculation of a \code{STIR} value for operations
\item \code{\link[=STIR_values_LUT]{STIR_values_LUT()}} for the reference data used for tillage operations
\item \code{\link[=calculate_indicators]{calculate_indicators()}} to calculate all management indicators
for a \code{management_df}
}
}
