#' @title Dataset of soil hydraulic properties for testthat
#' @description List with soil water contents (th) and unsaturated hydraulic conductivity values (ku) for spezific parameter of the uni- and bimodal hydraulic functions
#' of van Genuchten and Peters-Durner-Iden (PDI).
#' @docType data
#' @details
#' \describe{\item{List objects:}{}
#' \item{}{dataTestthat$th.vgm.uni: soil water contents for unimodal van Genuchten for parameter ths = 0.4, thr = 0, alfa = 0.02 and n = 1.5}
#' \item{}{dataTestthat$th.vgm.bi: soil water contents for bimodal van Genuchten for parameter ths = 0.4, thr = 0, alfa = 0.02, n = 2, w2 = 0.2, alfa2 = 1 and n2 = 10}
#' \item{}{dataTestthat$th.pdi.uni: soil water contents for unimodal PDI for parameter ths = 0.4, thr = 0, alfa = 0.02 and n = 1.5}
#' \item{}{dataTestthat$th.pdi.bi: soil water contents for bimodal PDI for parameter ths = 0.4, thr = 0, alfa = 0.02, n = 2, w2 = 0.2, alfa2 = 1 and n2 = 10}
#' \item{}{dataTestthat$ku.vgm.uni: soil water contents for unimodal van Genuchten for parameter Ks = 10, ths = 0.5, thr = 0, alfa = 0.02, n = 1.5 and tau = 0.5}
#' \item{}{dataTestthat$ku.vgm.bi: soil water contents for bimodal van Genuchten for parameter Ks = 10, ths = 0.5, thr = 0, alfa = 0.02, n = 1.5, tau = 0.5, w2 = 0.1, alfa2 = 0.1 and n2 = 3}
#' \item{}{dataTestthat$ku.pdi.uni: soil water contents for unimodal PDI for parameter Ks = 10, ths = 0.5, thr = 0, alfa = 0.02, n = 1.5, tau = 0.5 and omega = 0.001}
#' \item{}{dataTestthat$ku.pdi.bi: soil water contents for bimodal PDI for parameter Ks = 10, ths = 0.5, thr = 0, alfa = 0.02, n = 1.5, tau = 0.5, omega = 0.001, w2 = 0.2, alfa2 = 1 and n2 = 10}}
#' @usage data(dataSHP)
#' @keywords datasets
#'
'dataTestthat'

