% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AIC_HY.R
\name{AIC_HY}
\alias{AIC_HY}
\title{Akaike Information Criterion (AIC)}
\usage{
AIC_HY(Phi, n.data, n.par, corr = TRUE)
}
\arguments{
\item{Phi}{objective function value}

\item{n.data}{number of measured data}

\item{n.par}{number of adjustable parameters}

\item{corr}{correction term TRUE or FALSE (see details)}
}
\description{
Akaike Information Criterion with or without correction term. Expression from Ye et al. (2008). Correction term by Hurvich and Tsai (1989).
}
\details{
corr: \cr
If number of measurements is small compared to the number of parameters, AIC can be extended by a correction term.
}
\references{
Ye, M., P.D. Meyer, and S.P. Neuman (2008): On model selection criteria in multimodel analysis. Water Resources Research 44 (3) W03428, doi:10.1029/2008WR006803.

Hurvich, C., and C. Tsai (1989): Regression and time series model selection in small samples. Biometrika 76 (2), 297–307, doi:10.1093/biomet/76.2.297.

Peters and Durner (2015): SHYPFIT 2.0 User's Manual.

Akaike, H. (1974): A new look at statistical model identification, IEEE Trans. Autom. Control, AC-19, 716–723.
}
