% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantile_normalize_bart.R
\name{quantile_normalize_bart}
\alias{quantile_normalize_bart}
\title{Quantile normalization for predictors}
\usage{
quantile_normalize_bart(X)
}
\arguments{
\item{X}{A design matrix, should not include a column for the intercept.}
}
\value{
A matrix \code{X_norm} such that each column gives the associated
  empirical quantile of each observation for each predictor.
}
\description{
Performs a quantile normalization to each column of the matrix \code{X}.
}
\examples{
X <- matrix(rgamma(100 * 10, shape = 2), nrow = 100)
X <- quantile_normalize_bart(X)
summary(X)

}
