% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/py.rm.R
\name{py.rm}
\alias{py.rm}
\title{Remove a Python variable from R}
\usage{
py.rm(var.name, stopOnException = FALSE)
}
\arguments{
\item{var.name}{a character string containing a valid Python variable name}

\item{stopOnException}{if \code{TRUE} then \code{stop} will be called if a 
Python exception occurs, typically because the variable doesn't exist, 
otherwise only a warning will be flagged}
}
\description{
This function uses the \code{del} Python command to remove a variable and reclaim
its memory. Any exceptions, such as the one that would happen if the variable did
not exist, will be caught and ignored.
}
\examples{
py.assign("a", "foo bar")
py.get("a")
# [1] "foo bar"
py.rm("a")
\dontrun{
py.rm("a")
# Warning message:
# In py.rm("a") : Traceback (most recent call last):
#   File "<string>", line 2, in <module>
# NameError: name 'a' is not defined
}
}
