% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hardCode.R
\name{hardCode}
\alias{hardCode}
\title{Facilitate hard coding constants into R}
\usage{
hardCode(x, vname = "x", vert = TRUE, ...)
}
\arguments{
\item{x}{A vector (numeric, character, logical, or complex)}

\item{vname}{A string indicating the name of the vector that will be "created" in the code}

\item{vert}{A logical indicating whether the vector should be coded vertically (\code{TRUE}) or horizontally
(\code{FALSE})}

\item{...}{Additional arguments to \code{\link{cat}}}
}
\value{
Prints code (via \code{\link{cat}}) that will create the vector.  This code
can then be copied into other source code.  Returns nothing.
}
\description{
Hard coding isn't the best practice, but sometimes it's useful, especially in
one-off scripts for analyses. An typical example would be to select a large
number of columns in a dataset by their names.  This
function facilitate hard coding constants into R by printing the code from a
vector that would be needed to create that vector.
}
\examples{
# With characters
hardCode(letters[1])
hardCode(letters[1:3], vname = "new")
hardCode(letters[1], vert = FALSE)
hardCode(letters[1:3], vert = FALSE, vname = "new")

# With numbers
hardCode(3:5)
hardCode(3:5, vert = FALSE, vname = "num")

# With logicals
hardCode(TRUE)
hardCode(c(FALSE, TRUE), vert = FALSE)
hardCode(c(TRUE, FALSE, TRUE), vname = "newLogical")
}
\author{
Landon Sego
}
