% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Train.R
\name{Train}
\alias{Train}
\title{Train}
\usage{
Train(y, param = TRUE, const, initial)
}
\arguments{
\item{y}{A matrix, the training set.}

\item{param}{A logical scalar, if TRUE, the model is in parametric version, otherwise, a non-parametric one.}

\item{const}{A numeric vector, specifies the value of all global variables, if param = T, then const = c(N,n,d,rh,r,K,alpha); if param=FALSE, then const = c(N,n,d,rh,r,K,sigma_sqare).}

\item{initial}{A numeric vector, specifies the initial value of parameters over the continuous domain, if param = T, initial = c(pi_1,mean_1,cov_1, ..., pi_K, mean_K,cov_K), if param = F, initial = c(q1,q2, ..., qK).}
}
\value{
List of all parameters.
}
\description{
trains the parameters
}
\examples{
##parametric model test
initial=matrix(c(0.5,0,0,1,0,0,1,0.5,1,1,1,0,0,1),nrow=1)
const = c(0,1,2,0.1,0.1,2,2)
param=TRUE
y=matrix(c(1,3,1,0,1,1),nrow=2)
smart = Train(y,param,const,initial)$smart
hellingerScore = Train(y,param,const,initial)$HellingerScore
logLoss = Train(y,param,const,initial)$LogLoss
const[1] = Train(y,param,const,initial)$N

##non-parametric model test
param=FALSE
const = c(0,1,2,0.1,0.1,2,1)
initial = matrix(c(0,0,1,1),nrow=1)
y=matrix(c(1,3,1,0,1,1),nrow=2)
smart = Train(y,param,const,initial)$smart
hellingerScore = Train(y,param,const,initial)$HellingerScore
logLoss = Train(y,param,const,initial)$LogLoss
const[1] = Train(y,param,const,initial)$N
}

