% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fn_exp_numeric_viz.R
\name{ExpNumViz}
\alias{ExpNumViz}
\title{Distributions of numeric variables}
\usage{
ExpNumViz (data,target=NULL,type=1,nlim=NULL,fname=NULL,col=NULL,Page=NULL,
sample=NULL,scatter=FALSE,gtitle=NULL,theme="Default")
}
\arguments{
\item{data}{dataframe or matrix}

\item{target}{target variable}

\item{type}{1 (boxplot by category and overall), 2 (boxplot by category only), 3 (boxplot for overall)}

\item{nlim}{numeric variable unique limit. Default nlim is 3, graph will exclude the numeric variable which is having less than 'nlim' unique value}

\item{fname}{output file name}

\item{col}{define the fill color for box plot. Number of color should be equal to number of categories in target variable}

\item{Page}{output pattern. if Page=c(3,2), It will generate 6 plots with 3 rows and 2 columns}

\item{sample}{random selection of plots}

\item{scatter}{option to run scatter plot between all the numerical variables (default scatter=FALSE)}

\item{gtitle}{chart title}

\item{theme}{extra themes, geoms, and scales for 'ggplot2' (use theme from ggthemes package)}
}
\value{
returns collated graphs in PDF or JPEG format

Scatter plot for numeric data

Density plot for numeric data

Boxplot – by overall

Boxplot – by group (target variable)

Boxplot – by overall and group (target variable)
}
\description{
This function automatically scans through each variable and creates density plot, scatter plot and box plot for continuous variable.
}
\details{
This function automatically scan each variables and generate a graph based on the user inputs. Graphical representation includes scatter plot, box plot and density plots.
If input "target" is continuous then output is scatter plots

If input "target" is categorical then output is box plot.

If input "target" is NULL, means there is no target variable and this will generate density plot for all numeric features

To plot only scatter plot : target is categorical or NULL and scatter = TRUE
}
\examples{
## Generate Boxplot by category
ExpNumViz(mtcars,target="gear",type=2,nlim=25,Page = c(2,2),sample=4)
## Generate Density plot
ExpNumViz(mtcars,target=NULL,type=3,nlim=25,Page = c(2,2),sample=4)
## Generate Scatter plot by Dependent variable
ExpNumViz(mtcars,target="carb",type=3,nlim=25,Page = c(2,2),sample=4)
## Generate Scatter plot for all the numerical variables
ExpNumViz(mtcars,target="gear",scatter=TRUE,gtitle="Scatter plot",theme="Default",sample=2)
ExpNumViz(mtcars,target=NULL,scatter=TRUE,gtitle="Scatter plot",theme="Default",sample=2)
}
\seealso{
\code{\link[ggplot2:geom_boxplot]{geom_boxplot}}
}
