% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volcano_plot.R
\name{volcano_plot}
\alias{volcano_plot}
\title{Volcano Plot of Gene Expression Data}
\usage{
volcano_plot(
  data,
  number_points = 5,
  selected_points = NULL,
  interactive = FALSE,
  logFC_threshold = log2(1.5),
  FDR_threshold = 0.05,
  point_size = 2,
  lab_size = 4
)
}
\arguments{
\item{data}{A data frame containing gene expression data, containing an ID, log2 foldchange and FDR columns.}

\item{number_points}{Number of top up and down regulated points to label}

\item{selected_points}{Character vector of the IDs to label}

\item{interactive}{Should an interactive plotly graph be made?}

\item{logFC_threshold}{The foldchange threshold to define up and down regulated points}

\item{FDR_threshold}{The pval threshold to define up and down regulated points}

\item{point_size}{Size for the points}

\item{lab_size}{Size for the labels}
}
\value{
A ggplot object representing the volcano plot.
}
\description{
Creates a volcano plot showing the log2 fold change and FDR values with optional labelling of points.
}
\examples{
skeletalvis <- load_skeletalvis(demo=TRUE)

experiment_results <- get_experiment(skeletalvis, "GSE155118_1")

volcano_plot(experiment_results)
}
