% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_dist_spde.R
\name{make_mesh}
\alias{make_mesh}
\title{Make an R-INLA mesh based on a grid}
\usage{
make_mesh(
  grid = make_grid(),
  max.edge = 50,
  bound.outer = 150,
  cutoff = 10,
  offset = c(max.edge, bound.outer),
  ...
)
}
\arguments{
\item{grid}{A grid object to generate a mesh from.}

\item{max.edge}{The maximum allowed triangle edge length. One or two numeric values.
Passed to \code{inla.mesh.2d}.}

\item{bound.outer}{Optional outer extension value passed to \code{offset}.}

\item{cutoff}{Minimum distance allowed between mesh points.}

\item{offset}{Automatic extension distance used by \code{inla.mesh.2d}.}

\item{...}{Additional options passed to \code{inla.mesh.2d}.}
}
\value{
An object of class \code{inla.mesh}.
}
\description{
This function creates a mesh based on a given grid. While mesh construction
and validation should ideally be done manually, this function provides a
convenient default interface between a grid and \code{inla.mesh.2d}. It is designed
to support usage with \code{\link[=sim_ays_covar_spde]{sim_ays_covar_spde()}}, and the default parameters are
tuned for use with the default grid setup.
}
\examples{
\donttest{
if (requireNamespace("INLA")) {
  basic_mesh <- make_mesh()
  plot(basic_mesh)
}
}

}
