% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hazard_Methods.R
\name{hazard}
\alias{hazard}
\title{Create an object of class hazard.}
\usage{
hazard(hazardDF, partition = NULL)
}
\arguments{
\item{hazardDF}{Data.frame. Column 1 specifies the age-specific hazard rate of \emph{disease} in the population of interest, column 2 specifies the age-specific hazard rate for \emph{death} in the \strong{unaffected} population, and column 3 specifies the age-specific hazard rate for \emph{death} in the \strong{affected} population.  See details.}

\item{partition}{Numeric vector. The partition of ages, in years, over which to apply the age-specific hazard rates in \code{hazardDF}. If not supplied,  defaults to a partition that starts at 0 and increases in yearly increments.  See details.}
}
\value{
An object of class hazard.
}
\description{
Create a hazard object, required input for \code{\link{sim_RVped}}, \code{\link{sim_ped}}, and \code{\link{sim_life}} functions.
}
\details{
\code{hazardDF} must contain 3 columns that meet the following criteria:
\describe{
 \item{column 1:}{age-specific hazard rates of \emph{disease} for the population of interest}
 \item{column 2:}{age-specific hazard rates of \emph{death} for the \strong{unaffected} population.  If the disease of interest is sufficiently rare, so that death by the disease is rare, the user may choose to use the population, age-specific, hazard rates of death instead.}
 \item{column 3:}{age-specific hazard rates of \emph{death} for the \strong{affected} population.}
}

Users must provide \code{partition} in years; e.g. a hazard rate for a baby between 6 months and 1 year of age should have lower bound 0.5 years and an upper bound 1 year.  Additionally, \code{partition} must apply to all of the age-specific hazard rates in \code{hazardDF}.
}
\examples{
data(AgeSpecific_Hazards)

head(AgeSpecific_Hazards)
nrow(AgeSpecific_Hazards)

my_part = seq(0, 100, by = 1)
my_HR <- hazard(hazardDF = AgeSpecific_Hazards,
                partition = my_part)


my_HR
class(my_HR)
head(my_HR[[1]])
my_HR[[2]]


my_HR <- hazard(hazardDF = AgeSpecific_Hazards)
class(my_HR)
my_HR[[2]]

}
