% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ped_Methods.R
\name{new.ped}
\alias{new.ped}
\title{Create an object of class ped.}
\usage{
new.ped(ped_file)
}
\arguments{
\item{ped_file}{Data.frame. A pedigree, see details.}
}
\value{
An object of class ped.
}
\description{
Create an object of class \code{ped}, from a \code{data.frame}, required input for \code{\link{reassign_gen}}, \code{\link{censor_ped}}, and \code{\link{trim_ped}} functions.
}
\details{
The data frame supplied to \code{new.ped}, \code{ped_file}, \emph{must} contain the following columns:
\tabular{lll}{
\strong{name} \tab \strong{type} \tab \strong{description} \cr
\code{FamID} \tab numeric \tab family identification number \cr
\code{ID} \tab numeric \tab individual identification number \cr
\code{dadID} \tab numeric \tab identification number of father \cr
\code{momID} \tab numeric \tab identification number of mother \cr
\code{sex} \tab numeric \tab gender identification; if male \code{sex = 0}, if female \code{sex = 1} \cr
\code{affected} \tab logical \tab disease-affection status: \cr
\tab \tab \code{affected = TRUE} if affected by disease, and \code{FALSE} otherwise, \cr
}

Optionally, \code{ped_file} \emph{may} contain any of the following columns:
\tabular{lll}{
\strong{name} \tab \strong{type}\tab \strong{description} \cr
\code{available} \tab logical \tab availibility status; \cr
\tab\tab \code{available = TRUE} if available, and \code{FALSE} otherwise. \cr
\code{DA1} \tab numeric \tab paternally inherited allele at the assumed disease locus: \cr
\tab \tab \code{DA1} = 1 if rare variant is present, and 0 otherwise\cr
\code{DA2} \tab numeric \tab maternally inherited allele at the assumed disease locus: \cr
\tab \tab \code{DA2} = 1 if rare variant is present, and 0 otherwise\cr
\code{birthYr} \tab numeric \tab the individual's birth year \cr
\code{onsetYr} \tab numeric \tab the individual's year of disease onset, when applicable, otherwise \code{NA} \cr
\code{deathYr} \tab numeric \tab the individual's year of death, when applicable, otherwise \code{NA} \cr
\code{RR} \tab numeric \tab the individual's relative-risk of disease \cr
\code{Gen} \tab numeric \tab the individual's generation number relative to the eldest founder. \cr
\tab \tab For the eldest founder \code{Gen} = 1, for his or her offspring \code{Gen} = 2, etc. \cr
\code{proband} \tab logical \tab proband identifier: \cr
\tab \tab \code{proband = TRUE} if individual is the proband, and \code{FALSE} otherwise.\cr
}

\emph{We note that some of the optional fields above may be required for various ped functions}
}
\examples{
data(EgPeds)
head(EgPeds)

ped1 = new.ped(EgPeds[EgPeds$FamID == 1, ])
head(ped1, n = 3)
class(ped1)
summary(ped1)

AllPeds = new.ped(EgPeds)
head(AllPeds)
class(AllPeds)
summary(AllPeds)

}
