% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_theory.R
\name{calc_theory}
\alias{calc_theory}
\title{Find Theoretical Standardized Cumulants for Continuous Distributions}
\usage{
calc_theory(Dist = c("Beta", "Chisq", "Exponential", "F", "Gamma", "Gaussian",
  "Laplace", "Logistic", "Lognormal", "Pareto", "Rayleigh", "t", "Triangular",
  "Uniform", "Weibull"), params = NULL, fx = NULL, lower = NULL,
  upper = NULL, sub = 1000)
}
\arguments{
\item{Dist}{name of the distribution. The possible values are: "Beta", "Chisq", "Exponential", "F", "Gamma", "Gaussian",
"Laplace", "Logistic", "Lognormal", "Pareto", "Rayleigh", "t", "Triangular", "Uniform", "Weibull".
Please refer to the documentation for each package (i.e. \code{\link[stats]{dgamma}})
for information on appropriate parameter inputs.  The pareto (see \code{\link[VGAM]{dpareto}}), generalized
rayleigh (see \code{\link[VGAM]{dgenray}}), and laplace (see \code{\link[VGAM]{dlaplace}}) distributions
come from the \code{\link[VGAM]{VGAM}} package.  The triangular (see \code{\link[triangle]{dtriangle}}) distribution
comes from the \code{\link[triangle]{triangle}} package.}

\item{params}{a vector of parameters (up to 3) for the desired distribution (keep NULL if \code{fx} supplied instead)}

\item{fx}{a pdf input as a function of x only, i.e. fx <- function(x) 0.5*(x-1)^2; must return a scalar
(keep NULL if Dist supplied instead)}

\item{lower}{the lower support bound for a supplied fx, else keep NULL}

\item{upper}{the upper support bound for a supplied fx, else keep NULL}

\item{sub}{the number of subdivisions to use in the integration; if no result, try increasing sub (requires longer
computation time)}
}
\value{
A vector of the mean, standard deviation, skewness, standardized kurtosis, and standardized fifth and sixth cumulants
}
\description{
This function calculates the theoretical mean, standard deviation, skewness,
    standardized kurtosis, and standardized fifth and sixth cumulants given either a Distribution name (plus up to 3
    parameters) or a pdf (with specified lower and upper support bounds).  The result can be used as input to
    \code{\link[SimMultiCorrData]{find_constants}} or for data simulation.

    \bold{Note:} Due to the nature of the integration involved in calculating the standardized cumulants, the results are
    approximations.  Greater accuracy can be achieved by increasing the number of subdivisions (\code{sub}) used in the integration
    process.  However, the user may need to round the cumulants (i.e. using \code{round(x, 8)}) before using them in other functions
    (i.e. \code{find_constants}, \code{calc_lower_skurt}, \code{nonnormvar1}, \code{rcorrvar}, \code{rcorrvar2}) in order to achieve
    the desired results.  For example, in order to ensure that skew is exactly 0 for symmetric distributions.
}
\examples{
options(scipen = 999)

# Pareto Distribution: params = c(alpha = scale, theta = shape)
calc_theory(Dist = "Pareto", params = c(1, 10))

# Generalized Rayleigh Distribution: params = c(alpha = scale, mu/sqrt(pi/2) = shape)
calc_theory(Dist = "Rayleigh", params = c(0.5, 1))

# Laplace Distribution: params = c(location, scale)
calc_theory(Dist = "Laplace", params = c(0, 1))

# Triangle Distribution: params = c(a, b)
calc_theory(Dist = "Triangular", params = c(0, 1))
}
\references{
Headrick TC (2002). Fast Fifth-order Polynomial Transforms for Generating Univariate and Multivariate
    Non-normal Distributions. Computational Statistics & Data Analysis, 40(4):685-711. \doi{10.1016/S0167-9473(02)00072-5}.
    (\href{http://www.sciencedirect.com/science/article/pii/S0167947302000725}{ScienceDirect})

Headrick TC, Kowalchuk RK (2007). The Power Method Transformation: Its Probability Density Function, Distribution
    Function, and Its Further Use for Fitting Data. Journal of Statistical Computation and Simulation, 77, 229-249. \doi{10.1080/10629360600605065}.

Headrick TC, Sheng Y, & Hodis FA (2007). Numerical Computing and Graphics for the Power Method Transformation Using
    Mathematica. Journal of Statistical Software, 19(3), 1 - 17. \doi{10.18637/jss.v019.i03}

Thomas W. Yee (2017). VGAM: Vector Generalized Linear and Additive Models. R package version 1.0-3.
    \url{https://CRAN.R-project.org/package=VGAM}

Rob Carnell (2016). triangle: Provides the Standard Distribution Functions for the Triangle Distribution. R package
    version 0.10. \url{https://CRAN.R-project.org/package=triangle}
}
\seealso{
\code{\link[SimMultiCorrData]{calc_fisherk}}, \code{\link[SimMultiCorrData]{calc_moments}},
         \code{\link[SimMultiCorrData]{find_constants}}
}
\keyword{cumulants,}
\keyword{theoretical}
