\name{infer.haplos}
\alias{infer.haplos}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Infer haplotype configurations when phase is unknown}
\description{
  \code{infer.haplos} generates a haplotype object to be used in association analysis.
}
\usage{
infer.haplos(geno)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{geno}{a genotype data frame where each SNP is represented by two columns, one for each allele, in the form of \code{haplo.dat}}
}

\value{
  \code{infer.haplos} returns a list containing the following items
  \item{hapMat}{a dataframe containing all possible haplotype configurations with their respective likelihoods, for each individual.}
  \item{hap.freq}{haplotype frequencies estimated using the EM algorithm, and the standard errors of these frequencies.}
  \item{initFreq}{initial haplotype frequencies to be used by other SimHap functions.}

}
\references{
Excoffier, L., Slatkin, M.. (1995) Maximum-likelihood estimation of molecular haplotype frequencies in a diploid population. \emph{Molecular Biology Evolution}, 12(5):921-927.

McCaskie, P.A., Carter, K.W, Hazelton, M., Palmer, L.J. (2007) SimHap: A comprehensive modeling framework for epidemiological outcomes and a multiple imputation approach to haplotypic analysis of population-based data, [online] www.genepi.org.au/simhap.
}
\author{Pamela A. McCaskie}

\seealso{\code{\link{make.haplo.rare}}}
\examples{

data(SNP.dat)

# convert SNP.dat to format required by infer.haplos
haplo.dat <- SNP2Haplo(SNP.dat)

data(pheno.dat)

# generates haplotype frequencies and haplotype design matrix
myinfer<-infer.haplos(haplo.dat) 

# prints haplotype frequencies generated by infer.haplos
myinfer$hap.freq 

# generates haplo object where haplotypes with a frequency 
# below min.freq are grouped as a category called "rare"
myhaplo<-make.haplo.rare(myinfer,min.freq=0.05) 
mymodel <- haplo.quant(formula1=HDL~AGE+SBP+h.N1AA, formula2=HDL~AGE+SBP, 
	pheno=pheno.dat, haplo=myhaplo, sim=10)

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{manip}

